exactly one edge from M.

We will consider simultaneous matchings on bipartite graphs(SIM-BM) (Kutz *et al.* 2008).

Definition 3. An overlapping bipartite graph *is a bipartite* graph G = hA ∪ B, Ei and two sets S and T *such that* A = S ∪ T, A ∩ B = ∅*, and* S ∩ T 6= ∅.

Definition 4. Let hA ∪ B, Ei and S, T *be an overlapping* bipartite graph. A simultaneous matching is a set of edges M ⊆ E such that M ∩ (S × B) and M ∩ (T × B) are matchings that cover S and T*, respectively.*
In the following, we use the convention that a set of vertices P is a subset of the partition A. We write N(P) for the neighborhood of P, P
S = P ∩ (S \ T), P
T = P ∩ (T \ S)
and P
ST = P ∩ S ∩ T. SIM-BM problems frequently occur in real world applications like production scheduling and timetabling. We introduce here a simple exam timetabling problem that will serve as a running example. Running example. We have 7 exams offered over 5 days and 2 students. The first student has to take the first 5 exams and the second student has to take the last 5 exams. Due to the availability of examiners, not every exam is offered each day. For example, the first exam cannot be on the last day of the week. Only one exam can be sat each day. This problem can be encoded as a SIM-BM problem. A represents the exams and contains 7 vertices X1 to X7. B represents the days and contains the vertices 1 to 5. S = [X1, X2, X3, X4, X5]
and T = [X3, X4, X5, X6, X7]. We connect vertices between A and B *to encode the availability restrictions of the* examiners. The adjacency matrix of the graph is as follows:
1 2 3 4 5 A
S = S \ TX1 *∗ ∗ ∗ ∗*
X2 ∗ ∗

$$\underline{{\;\;\;\;\;\;\;\;\;\;\;\;}}$$

![0_image_0.png](0_image_0.png)

* [10] M. C.  

![0_image_1.png](0_image_1.png)

```
        A
         ST = S ∩ T
                 X3 ∗ ∗ ∗
                 X4 ∗ ∗ ∗
                 X5 ∗ ∗ ∗ ∗ ∗
        A
         T = T \ SX6 ∗ ∗
                 X7 ∗ ∗ ∗ ∗
 Finding a solution for this SIM-BM problem is equivalent
to solving the timetabling problem.

```

## Simultaneous Bipartite Matching

We now consider how to find a simultaneous matching. Unfortunately, this problem is NP-complete in general (Kutz et al. 2008). Our contribution here is to identify a necessary and sufficient condition for the existence of a simultaneous matching based on an extension of Hall's theorem (Hall 1935). We use this to show that a simultaneous matching on a convex bipartite graph can be found in polynomial time.

In the following, let G0(u,v)
be the subgraph of the overlapping bipartite graph G that is induced by choosing an edge
(*u, v*) to be in the simultaneous matching. If u ∈ AST then G0(u,v) = G − {*u, v*}. If u ∈ AS (and symmetrically if u ∈ AT) then G0(u,v) = hV − {u}, E \ {(u 0, v)|u 0 ∈ S}i.

If M is a SIM-BM in G0(u,v)
, then M∪{(*u, v*)} is a SIM-BM
in G. Since the edge (*u, v*) is implied throughout, we write G0 = G0(u,v)
. In addition, we write N0(P) = NG0 (P).

## Extension Of Hall'S Theorem

Hall's theorem provides a necessary and sufficient condition for the existence of a perfect matching in a bipartite graph.

Theorem 1 (Hall Condition (Hall 1935)). Let G =
hA ∪ B, Ei such that A ∩ B = ∅*. There exists a perfect* matching iff |N(P)| ≥ |P| for P ⊆ A.

Interestingly we only need a small adjustment for simultaneous matching.

Theorem 2 (Simultaneous Hall Condition (SIM-HC)). Let G = hA ∪ B, Ei and sets S, T *be an overlapping bipartite graph. There exists a* SIM-BM*, iff* |N(P)| + |N(P
S) ∩
N(P
T)| ≥ |P| for P ⊆ A.

Proof. We prove SIM-HC by induction on |A|. When |A| = 1, the statement holds. Let |A| = k > 1.

If AS = ∅ or AT = ∅ then SIM-HC reduces to the condition of Hall's theorem and the statement is true for that reason. Hence, we assume AS 6= ∅ and AT 6= ∅. We show that there is an edge (*u, v*) that can be chosen for a simultaneous matching and the graph G0(u,v) will satisfy SIM-HC. Following (Diestel 2006), page 37, we consider two cases. The first case when all subsets of A satisfy the strict SIM-HC,
namely, |N(P)|+|N(P
S)∩ N(P
T)| > |P| and the second case when we have an equality.

Case 1. Suppose |N(P)| + |N(P
S) ∩ N(P
T)| > |P| for all sets P ⊂ A. As AS 6= ∅ we select any edge
(u, v), u ∈ AS and construct the graph G0(u,v)
(the case u ∈ ATis symmetric). For any set P ⊂ A \ {u} we consider two cases: either v /∈ N(P) or v ∈ N(P). In the first case, the neighborhood of P is the same in G and G0, so the SIM-HC holds for P. In the case that v ∈ N(P),
then either v is a shared neighbor of P
S and P
T, which means that N0(P
S) ∩ N0(P
T) = N(P
S) ∩ N(P
T) − 1 but N0(P) = N(P) by construction, or v is a neighbor of P
S but not of P
T. Therefore N0(P) ≥ N(P) − 1.

But N0(P
S) ∩ N0(P
T) = N(P
S) ∩ N(P
T) by construction. In either case, |N0(P)| + |N0(P
S) ∩ N0(P
T)| ≥
|N(P)| + |N(P
S) ∩ N(P
T)| − 1 ≥ |P| for any set P in G0. By the inductive hypothesis there exists a simultaneous matching in it.

Case 2. Suppose that there exists a set P ( A such that |N(P)|+|N(P
S)∩N(P
T)| = |P|. Let Q = hA0 ∪ B0, E0i

such that A0 = A \ P, B0 = B \ (N(P S) ∩ N(P T)) and E 0 = {(u, v) ∈ E ∩ (A 0 × B 0) | (u ∈ A S0=⇒ v /∈ N(P) \ N(P T)) ∧ (u ∈ A T 0=⇒ v /∈ N(P) \ N(P S)) ∧ (u ∈ A ST 0=⇒ v /∈ N(P)) } There exists a simultaneous matching in G − Q by the
inductive hypothesis. We claim that the SIM-HC holds also for Q. This implies that, by the inductive hypothesis, there exists a simultaneous matching in Q. Suppose there exists a set P
0 ⊆ A0that violates the SIM-HC in Q.

We denote as N(P) the neighborhood of P in G and NQ(P
0) as the neighborhood of P
0in Q. We know that the sets P
0and P are disjoint. We observe that N(P ∪