search for desirable properties of hybrid update operators is an interesting future research area.

There are also many more properties still to be examined, among them decidability as well as complexity of reasoning. Since we cannot expect the **operator to** perform any better than the stable model semantics and the classical update operator it is based on, its tractable approximations need to be defined and examined.

The well-founded semantics for logic programs (Gelder et al. 1991) and its version for hybrid MKNF knowledge bases (Alferes et al. 2009) constitute crucial starting points. The recent research on ontology evolution (see (Flouris et al. 2008) for a survey) can help design tractable update operators which, at the **same time, offer** the necessary functionality to be interesting for use in practice.

In this paper, the TBox was considered static and was treated in the same way as integrity constraints in (Winslett 1990). This approach to handling integrity constraints in the context of updates has been criticized in **the literature**
(Herzig and Rifi 1999; **Herzig 2005), as in certain cases it does not provide the**
expected results. However, the proposed solutions are defined only for the propositional case and a preliminary examination showed that their treatment of equivalences, such as the TBox definitions used in Example **3.6, is not always the expected**
one. Further investigation is needed to find suitable solutions to these problems in the context of ontology updates. Furthermore, in truly dynamic environments, the TBox should also be allowed to be updated. We believe that finding appropriate update operators for ontologies is still a largely open research question.

The large body of work on rule updates (Leite 2003; **Alferes et al. 2005), and**
more recently (Delgrande et al. 2008), also needs to be exploited in the attempts to define an update operator that can deal with the evolution of both rules and ontologies.

Finally, while incorporating new knowledge in a knowledge base is important, the complementary task of removing a certain piece of information is **also important. Hence, hybrid erasure operators should be studied and related to hybrid update operators. The work on erasure (Giacomo et al. 2007) in description logics as**
well as forgetting in both description logics (Wang et al. 2009) and logic programs (Eiter and Wang 2008) should be the starting points of this research.

To conclude, in this paper, to the best of our knowledge, we proposed the first update operator for hybrid knowledge bases. We deal with a constrained but interesting scenario in which a TBox and nonmonotonic rules represent static knowledge, policies, norms and default preferences, and the evolving ABox represents the open and dynamic environment. We illustrated the behaviour of our operator on a simple example. The operator can be used in realistic scenarios where the general notions and rules are relatively fixed, and individuals tend to change their state frequently.

This is the case of many real life institutions where stakeholders change their state on a regular basis while the general rules and structures change only occasionally.

We proved a number of properties of our operator, among which its **relations**
with the theories it was based on, such as the stable model semantics for logic programs (Gelfond and Lifschitz 1988), the MKNF semantics for hybrid knowledge