The Semantic Web was initiated almost a decade ago with an ambitious plan regarding the sharing of metadata and knowledge in the Web, enhanced with reasoning services for advanced new applications (Berners-Lee et al. 2001). Since then, the considerable amount of research devoted to this endeavour originated important foundational results and a deeper understanding of the issues involved, while identifying important conclusions regarding future developments, **namely that:**
1. Ontologies are necessary and useful for knowledge representation in the Semantic Web. The formalisms developed, e.g. OWL, are powerful enough to capture existing modelling languages used in software engineering, and extend their capabilities. Ontologies are usually based on decidable, as well as tractable, fragments of Classical Logic, such as the Description Logics (DL)
(Baader et al. 2003). They adopt the open world assumption **(OWA) i.e. they**
view a knowledge base, by assumption**, to be potentially incomplete, hence a** proposition p is false only if the knowledge base is inconsistent with p**. This** suits well the open nature of such systems where complete knowledge about the environment cannot be assumed.

2. Rules are fundamental to overcome the limitations found in OWL. They enjoy formal, declarative and well-understood semantics, the stable model semantics (Gelfond and Lifschitz 1988) and its tractable approximation, the threevalued well-founded semantics **(Gelder et al. 1991) being the most prominent**
and widely accepted. These semantics adopt the **closed world assumption** (CWA) i.e. the knowledge base is assumed **to contain complete information.** Consequently, a proposition p **is considered false whenever it is not entailed**
to be true. This type of negation is usually dubbed default negation or **weak**
negation, to distinguish it from the classical negation **used in Classical Logic.** Rules can naturally express assumptions, policies, preferences, norms and laws, and provide constructs which are more natural for software developers (as used in Relational Databases and Logic Programming).

3. The open and dynamic character of the Semantic Web requires new knowledge based systems to be equipped with mechanisms to evolve.

Indeed, the growing availability of information requires the support **of dynamic**
data and application integration, automation and interoperation of **business processes and problem-solving in various domains, to enforce correctness of decisions,**
and to allow traceability of the knowledge used and of the decisions taken. In these scenarios, ontologies provide the logical foundation of intelligent access and information integration, while rules are used to represent business policies, regulations and declarative guidelines about information, and mappings between **different information sources.**
Over the last decade, there have been many proposals for integrating DL based monotonic ontologies with nonmonotonic rules (see (Hitzler and Parsia 2009) for a survey). Recently, in (Motik and Rosati 2007), Hybrid MKNF Knowledge Bases were introduced, allowing predicates to be defined concurrently in both an ontology and a set of rules, while enjoying several important properties. There is even a tractable variant based on the well-founded semantics that allows for a top-down