In logic programming, the set of interpretations usually forms a partial order that is usually ordered by the subset relation. In case of MKNF interpretations, the partial order is determined by the superset relation.

The following definitions introduce the least and greatest elements and lower and upper bounds of a subset of a partially ordered set.

Definition A.2 (**Least and Greatest Element**)
Let P be a partially ordered set, S ⊆ P and a ∈ S. Then a is the **least element of**
S if for every b ∈ S it holds that a ≤ b, and a is the greatest element of S **if for** every b ∈ S **it holds that** b ≤ a.

Definition A.3 (**Lower and Upper Bound**)
Let P be a partially ordered set, S ⊆ P and a ∈ P. Then a is a **lower bound of** S if for every b ∈ S it holds that a ≤ b, and a is an upper bound of S **if for every** b ∈ S it holds that b ≤ a.

Combining the previous notions, we obtain the notion of a least upper **bound**
(supremum) and greatest lower bound (infimum). Definition A.4 (**Supremum and Infimum**)
Let P be a partially ordered set, S ⊆ P and a ∈ P. Then a is the **supremum of** S,
denoted by a = sup(S**), if it is the least element of the set of upper bounds of** S, and a is the infimum of S, denoted by a = inf(S**), if it is the greatest element of** the set of lower bounds of S
The next notion of a directed set **plays an important role in defining when a**
function on a partial order is continuous. It is also required in order **to define**
a stricter structure than a partial order, the complete partial order**. We need to** introduce both these notions in order to formulate the Kleene Fixed **Point Theorem** which describes one property of continuous functions on complete **partial orders.**

## Definition A.5 (**Directed Set**)

A directed set is a pair (D, ≤) where D is a non-empty set, ≤ **is a reflexive and**
transitive relation over D and for any elements a, b ∈ D **there exists some** c ∈ D such that a ≤ c and b ≤ c.

As can be seen, in a directed set, every pair of elements has an upper bound that also belongs to the set. This property can be naturally extended to **finite subsets** of the directed set. Proposition A.6 Let (D, ≤) be a directed set and S a finite subset of D. Then D **contains an upper** bound of S.