Thus, appropriate ways of updating ontologies in general, and TBoxes in particular, still need to be explored and pose an important open problem on **its own. In**
our current paper we follow the mentioned ontology update literature and focus on ABox updates, leaving the TBox static throughout the update process.

Updates were also investigated in the context of Logic Programs. Earlier approaches based on literal inertia (Marek and Truszczynski 1998) proved not sufficiently expressive for dealing with rule updates, leading to the development of rule update semantics based on different intuitions, principles and constructions, when compared to their classical counterparts. For example, the introduction of the **causal**
rejection principle (Leite and Pereira 1997) lead to several approaches to rule updates (Alferes et al. 2000; Leite 2003; Eiter et al. 2002; **Alferes et al. 2005), all of**
them with a strong syntactic flavour which makes them very hard to **combine with** belief update operators that are semantic in their nature. Other existing approaches to updates of Logic Programs (Sakama and Inoue 2003; Zhang and Foo 2005; **Delgrande et al. 2008)**
have different problems, such as, for example, not being immune to tautological updates. It has been shown in (Eiter et al. 2002) that the above mentioned rationality postulates, set forth in the context of Classical Logic, are inappropriate for dealing with updates of Logic Programs.

In order to develop an appropriate update operator for hybrid knowledge bases, one has to somehow combine these apparently irreconcilable approaches to updates, a problem that is far away from having an appropriate solution.

In this paper, we take an important first step in addressing the updates of hybrid knowledge bases. Following the state of the art in ontology updates **(Liu et al. 2006;** Giacomo et al. 2007), we choose a constrained scenario - which is, nevertheless, rich enough to encompass many practical applications of hybrid theories - in which only the ABox is allowed to evolve, while the TBox is kept static. We add rule support to this scenario by augmenting the traditional immediate consequence **operator used**
in logic programming with the classical update operator. The resulting framework is significantly more expressive than those of (Liu et al. 2006; **Giacomo et al. 2007)** and allows for a seamless two-way interaction between Logic Programming rules and Description Logic axioms. The consequences of rules are also subject to update through the ABox updates, making it possible to use rules to represent default preferences or behaviour and later directly impose exceptions to those rules.

The resulting update semantics enjoys several desirable properties, namely it:
- **generalises the stable model semantics (Gelfond and Lifschitz 1988).** - **generalises, under reasonable assumptions, the MKNF semantics for hybrid**
knowledge bases (Motik and Rosati 2007).

- **generalises, under reasonable assumptions, the minimal change update operator (Winslett 1990).**
- **adheres to the principle of primacy of new information (Dalal 1988), so every**
model resulting from the update by an ABox A **is a model of** A.

- **is syntax-independent w.r.t. the TBox and ABox, i.e. yields the same result**
with equivalent TBoxes and when updating by equivalent ABoxes.

To the best of our knowledge, this is the first proposal of an update semantics