
## 2.2 Description Logics

Description Logics (DLs) (Baader et al. 2003) are (mostly) decidable fragments of first-order logic that are frequently used for knowledge representation in practical applications. In the following we assume that some Description Logic is **used to** describe an ontology. We do not choose any specific Description Logic, we only assume that the ontology expressed in it is composed of two distinguishable parts: a TBox with concept and role definitions using the constructs of the **underlying** description logic, and an ABox with individual assertions, i.e. assertions of the form C(a) and R(a, b) where a, b are constants, C is a concept expression and R **is a role**
expression of the un derlying description logic. This distinction is important to us as we treat the two types of knowledge in different ways - the TBox is **considered** static while the ABox is allowed to evolve. As was noted in the introduction, our main reason for this is that we believe existing update operators to be unsuitable for updating concept definitions contained in the TBox. We also assume that the axioms of the underlying DL can be translated into first-order logic and for the sake of simplicity we assume that the TBox and ABox already contain these **translations** instead of the syntactic constructs of the underlying DL.

## 2.3 Hybrid Mknf Knowledge Bases

We make use of the general MKNF framework to give a semantics to hybrid knowledge bases composed of an ontology and a normal logic program. The following definition introduces the notion of a rule as we use it in the following: Definition 2.7 (**Rule**) A rule **is any open MKNF formula of the form**
K p ⊂ K q1 ∧ K q2 ∧ · · · ∧ K qk ∧ not s1 ∧ not s2 ∧ · · · ∧ not sl (1)
where k, l are non-negative integers and p, qi, sj **are first-order atoms for any** i ∈
{ 1, 2, . . ., k } , j ∈ { 1, 2, . . . , l }. Given a rule r **of the form (1), the following notation** is also defined:

$$\mathbf{\partial}\cdot\mathbf{\partial}\Big\}\ \ ,$$

H(r) = K p ,
H∗(r) = p ,

$${\mathrm{T}})=\{$$

B
+(r) = { K q1, K q2**, . . . ,** K qk } ,

$B^{-}(r)=\{$**not**$s_{1},$**not**$s_{2},$**$\ldots,$**not**$s_{l}\}$  $B(r)=B^{+}(r)\cup B^{-}(r)$.  
H(r) is dubbed the head of r, H∗(r) the first-order head of r, B+(r) the **positive**
body of r, B−(r) the negative body of r and B(r) the body of r. A rule r **is called**
definite if its negative body is empty. A rule r is called a fact **if its body is empty.**
A program is a set of rules. A definite program **is a set of definite rules.**
As was shown in (Lifschitz 1991), the MKNF semantics generalises the stable model semantics for logic programs. In particular, every logic programming rule of