
## Critical Analysis

Stability of schedules is always measured by comparison of an initial production schedule x **with a**
revised schedule x
′
**. Various characteristics of the schedules** x, x′ **may differ from each other. In**
particular, the following aspects have to be considered to be the basis for a further analysis.

1. Different starting times of operations, along with different **completion times of the jobs.** 2. Different operation sequences.

3. Different machine assignments of operations.

Consequently, approaches measuring the stability of schedules are based on either one characteristic or combine several characteristics to an overall stability **measure.**
Stability measures express the difference in a quantitative way, given an overall idea of how 'different' schedules are. Existing approaches define stability with respect to starting time changes of operations (Cowling et al., 2004; Cowling and Johansson, 2002; Lin et al., 1994; Rangsaritratsanee et al., 2004; Wu et al., 1993) or changes of operation sequences (Iima, 2005). A distinction between earlier and later starting operations is sometimes made (Lin et al., 1994). This expressed the fact that on one hand an earlier execution is critical in the sense of schedule stability, while on the other hand a later execution does not lead to problems for the organization. The difference between schedules is of particular importance **as changes of the production planning have** an organizational impact, e. g. on required material, suppliers, etc. A stability measure of schedules therefore should express the impact of the changes on the organization.

Reviewing existing approaches of schedule stability, one can observe that they do not take into consideration the influence of the point in time when the changes **occur. While the absolute deviation**
of the starting times from the initially scheduled sjk **plays a role, it is not further analyzed whether**
the changes appear close to the actual rescheduling moment or at the end of the planning horizon. In many real world applications of scheduling, immediate changes will however have a different impact compared to changes happening in e. g. several weeks. The reason behind this can be seen in the time needed to implement the changes made to the production schedule. Communication with suppliers and customers requires time.

## 3 Proposition Of A Novel Approach A Generalized Instability Measure

To overcome the limitations described in the previous section, we propose a novel approach measuring the instability **of schedules. A measure for instability is defined in such a way that larger values refer to**
a larger instability. This is in contrast to approaches found in the literature, which wrongly denote the measures as measures of stability, although the computed values increase with increasing instability.

The concept is based on starting times of operations, and measures instability of schedules analyzing two aspects: 1. The size of the deviation of the starting times.

2. The point of time, when the deviation occurs.

The first aspect, the size of the deviation of the starting times, can easily be measured by comparing the starting times sjk and s
′

jk **of the operations. Expression (3) computes their absolute difference,**
comparing the initial schedule x **and the revised one** x
′
.