
## Overall Formula

A computation of the total impact of the starting time changes and therefore the instability instab(x, x′)
combines the relative importance of the impact with the size **of the change. Expression (8) gives the**
precise formula.

$$instab(x,x^{\prime})=\sum_{j}\sum_{k}imp(dist_{jk})\Delta_{jk}=\sum_{j}\sum_{k}\left(I^{\min(s_{jk},s^{\prime}_{jk})-t_{0}}\quad|s^{\prime}_{jk}-s_{jk}|\right)\tag{8}$$

In brief this means that combinations of values sjk, s′jk close to t0 **and big changes of the starting**
times |sjk − s
′

jk| **lead to a high impact. On the other hand, small changes of** sjk to s
′

jk **and changes**
occurring towards the end of the planning horizon do not contribute as much to the impact measure. It becomes clear that the required effort for computing Expression (8) increases with the number of operations. Also, the exponential component adds to the running time of of the formula. For a practical application, e. g. in a metaheuristic approach employing local search, where numerous evaluations of Expression (8) are required, a closer look at the running time behavior of our approach will become necessary.

## 4 Discussion And Conclusions

An approach to measure the instability of schedules in a dynamic manufacturing environment has been presented. The concept integrates two aspects into a single measure, namely the difference of starting times and the significance of the changes depending on when they occur. As a result, the concept generalizes approaches known from literature by providing the possibility of assigning a relative importance of the changes.

The proposed instability measure is more general, yet it includes the special case of Wu et al. (1993)
for a chosen value of I = 1. In any other case however, the determination of an appropriate I **requires** considerable more information compared to existing approaches. Small values of I **lead to a fast**
decrease of the impact, while large values tend to discriminate less between the changes.

Given the possibility to collect information about the relative importance of the changes as described, the approach may reflect the actual practical situation of dynamic scheduling in manufacturing environments more closely. Future research will therefore focus on the evaluation of the applicability of the approach in dynamic machine scheduling situations. Such an **attempt could be experimentally-driven,** investigating the obtained results when making use of the proposed measure, e. g. for an exemplary dynamic job-shop- or flow-shop scheduling environment. Different rescheduling factors should be examined, and the impact of well-chosen rescheduling reasons **(disturbances) on the obtained schedule**
should be studied. This also implies an experimental comparison of the proposed measure to approaches known from the literature.

## References

R.J. Abumaizar and J. A. Svestka. Rescheduling job shops under disruptions. **International Journal**
of Production Research**, 35(7):2065–2082, 1997.**
Haldun Aytug, Mark A. Lawley, Kenneth McKay, Shantha Mohan, and Reha Uzsoy. Executing production schedules in the face of uncertainties: A review and some future directions. **European Journal**
of Operational Research**, 161:86–110, 2005.**