we need no special instances of α causes α to hold (even though **α causes α** for a particular α can be explicitly asserted). Similarly, if α **is equivalent to** γ and β causes α hold, this does not mean that β causes γ **holds. This feature**
contrasts with [Bel06, Boc03, GLL+**04, HP01a, HP01b, G.98] although in the**
context of actions such confusion is less harmful. Some authors have already introduced notions related to our causal and ontological atoms. In **[Kau91, CD94],**
there are "axioms" which can be loosely related to our causal and ontological atoms. Our work investigates how "explanations" are obtained from such causal and ontological information. On the other hand, we have not worked here on the important subject of what can precisely be done from these explanation atoms. This is left for future work, since we think that the formalization task is also a crucial one. As for designing some plan recognition or some abductive reasoning from our work, this is possible with simple additions over our formalism. **Let us** just give one indication here: from the sets of conditions for each explanation atom, "best explanations" for a given set set of α**'s can be defined.**
Also as future work we should relax some of the strong restrictions **on the**
notion of "cause" made here. We could introduce some ranking among the causal atoms, in order to cope with cases such as "smoking causes **cancer".**
Then, we could introduce the temporal aspect which is important as **soon as** causation is involved, by adding a special temporal parameter.

We have designed a system in answer set programming that implements most of the formalism introduced above. It is restricted to predicates of arities 0 or 1 (this could be easily extended) and the simplification part is not fully completed (this is much harder to modify, since the computation would be seriously more complex, but this strong simplification does not appear to be crucial). It works for examples of reasonable size, but it should be expandable for some real life examples, thus showing that our two main goals have been reached (simplicity of the formalization by a user, and efficiency of the computation). Our present translation in Answer set programming cannot be considered as a competitor with achieved proposals such as the "causal calculator" CCalc of [GLL+**04], but**
it can at least give some indications that a real abductive system (for instance)
can be built over our present proposal. We can e.g. deal with the "cooking example" of [Kau91, CD94] by adding only a few rules to our program.

As another future work, we should consider ontological links less elementary than the taxonomic relations considered in the present system. We think however that the present system is a good basis for a really practical system.

## References

[Bar03] Chitta Baral. Knowledge representation, reasoning and declarative problem solving**. Cambridge University Press, January 2003, 2003.**
[BC99] Ph. Besnard and M.-O. Cordier. Inferring causal explanations.

In *5th Eur. Conf. on Symbolic and Quantitative Approaches to* Reasoning, in LNAI 1638, Springer**, pages 55–67, London, 1999.**