O: An ontology in the form of a set of IS-A **links between two items which**
can appear in a causal statement.

E.g., T emperature 39 →IS−A F ever **T emperature**, T emperature 41 →IS−A F ever **T emperature**, Heard loud bell →IS−A Heard **bell**,
Heard sof t bell →IS−A Heard **bell**.

W**: A classical propositional theory expressing truths (i.e., incompatible facts,**
co-occurring facts, . . .). E.g., Heard sof t bell → ¬Heard loud **bell**).

Intuitively, propositional symbols denote elementary properties describing states of affairs, which can be "facts" or "events" such as F ever **T emperature**,
On alarm, Heard **bell**.

The causal statements express causal relations between facts or events expressed by these propositional symbols. Some care is necessary when providing these causal and ontological atoms. If "Flu causes F ever **T emperature**",
we will conclude Flu *explains* T emperature 39 from **T emperature** 39 →IS−A
F ever T emperature, but we cannot state Flu causes T emperature 39: we require that the causal information is provided "on the right level" and **in this**
case, T emperature **39 is not on the right level.**
Besides, our restricted ontology could be termed "taxonomy". The formal system we introduce below is meant to infer, from such premises C ∪ O ∪ W**, formulas denoting explanations. This inference will be denoted** ⊢C .

The ontological atoms express some common sense knowledge which **is necessary** to infer these "explanations". Notice that a feature of our formalism is that standard implication alone cannot help to infer explanations [BCM06, BCM07].

In this section, α, β, . . . denote the propositional atoms and Φ, Ψ, . . . **denote**
sets thereof.

## Atoms

1. *Propositional atoms*: **α, β, . . .**.

2. *Causal atoms*: **α causes β**.

3. *Ontological atoms*: α →IS−A β.

4. Explanation atoms: α explains β because *possible* Φ.

An ontological atom reads: α **is a** β. An explanation atom reads: α is an explanation for β because Φ *is possible.*
Notation: **In order to help reading long formulas, explanation atoms are**
sometimes abbreviated as α explains β bec *poss* Φ.

## Formulas

1. *Propositional formulas***: Boolean combinations of propositional atoms.**
2. *Causal formulas***: Boolean combinations of causal or propositional atoms.**