# The Exact Closest String Problem As A Constraint Satisfaction Problem

Tom Kelsey∗
University of St Andrews St Andrews, KY16 9SX United Kingdom tom@cs.st-andrews.ac.uk Lars Kotthoff University of St Andrews St Andrews, KY16 9SX United Kingdom larsko@cs.st-andrews.ac.uk

## Abstract

We report (to our knowledge) the first evaluation of Constraint Satisfaction as a computational framework for solving closest string problems. We show that careful consideration of symbol occurrences can provide search heuristics that provide several orders of magnitude speedup at and above the optimal distance. We also report (to our knowledge) the first analysis and evaluation - using any technique - of the computational difficulties involved in the identification of all closest strings for a given input set. We describe algorithms for web-scale distributed solution of closest string problems, both purely based on AI backtrack search and also hybrid numeric-AI methods.

## 1 Introduction

The closest string problem (CSP) takes as input a set of strings of equal length over a fixed alphabet.

A solution is a string with the smallest possible maximum Hamming distance from any input string.

(Strictly speaking, distance with respect to any suitable metric can be minimised; the Hamming distance is the standard edit distance metric used for this class of problems.) CSP has applications in coding and information theories (in these fields the problem is also known as minimum radius), but when the input strings consist of nucleotide sequences over the letters A, C, G and T, (or of mRNA sequences over the letters A, C, G and U, or of amino acid sequences over an alphabet of size 20) the CSP has important applications in computational biology (where the problem class is also known as centre string). Examples include the identification of consensus patterns in a set of unaligned DNA sequences known to bind a common protein [12], finding conserved secondary structure motifs in unaligned RNA sequences [19],
discovering motifs in ranked lists of DNA sequences [6], finding DNA regulatory motifs within unaligned noncoding sequences [22], the identification of sister chromatids by DNA template strand sequences [8],
and DNA motif representation with nucleotide dependency [2]. Our aim is to provide theoretical and practical results - together with empirical supporting evidence - that lead to improved CSP solution for biological problems, so in this paper the base alphabet Σ will always consist of four symbols.

A Constraint Satisfaction Problems (CSP) consists of a set of constraints involving variables taking discrete values. A solution to a CSP is an assignment of values to variables such that no constraint is violated. CSP solvers are used for many important classes of problems for which solutions must take discrete values, but, to our knowledge, the closest string problem has not been modelled and solved as a CSP. The research question under consideration, therefore, is "Is CSP a useful framework for solving CSP instances?"
In this paper we investigate approaches to developing and solving such models. We demonstrate that a careful choice of search heuristic can give several orders of magnitude speedup in general. We show that CSP modelling and solution are effective tools for the related problem of obtaining all closest strings.

We consider the distribution of closest string problems across a cloud (or grid, or cluster) of computing nodes, and identify two potential super-linear speedups that can be achieved in practice. Finally we