solution. It returns false if either the computation has timed out, or the node has suddenly stopped working for some reason. If all solutions to the input CSP are required, then we modify Algorithm 1 so that all solutions found so far are returned whenever the Solved? predicate fails.

It should be stressed that Algorithm 1 is not a contribution to the results of this paper. The algorithm has been implemented, tested, optimised and deployed on clusters, grids and clouds. It has been - and is being - used to attack CSP instances requiring an estimated 200 CPU years for exact solution [4].

## 3.1.1 Distributed Csp**S Using Minion**

In common with Integer Programming problems, CSPs distribute naturally across multiple compute nodes [7]. Significant research has been invested in the distribution of CSPs across multiple computers [3, 25, 18]. In particular the area of balancing the load among the nodes is an area of active research [20].

Instead of the more sophisticated approaches, we choose a simple technique that does not impose any constraints on the problem to be solved and is targeted towards very large problems. Our algorithm closely follows Algorithm 1 - we run Minion with a time out and when this time out is reached, we split the remaining search space into two parts. The subproblems are inserted into a FIFO queue and processed by the computational nodes, splitting them again if necessary.

One of the drawbacks of our approach is that it does not parallelise small problems well. For n compute nodes, we only achieve full capacity utilisation after log2 n splits, i.e. after timeout × log2 n seconds. We do not consider this to be a limiting factor however because the split timeout can be adapted dynamically to at first quickly split the problem and when full utilisation has been achieved increase it. For the large problems we have focused on when implementing this technique, requiring days or even years of CPU time, this is not a limiting factor.

The main advantage of our way of distributing problems over other approaches is that we explicitly keep the split subproblems in files. This means that at any point we can stop, suspend, resume, move or cancel the computation and lose a maximum of timeout×n seconds of work, much less in practice.

Apart from contributing to the robustness of the overall system, we can also easily move subproblems that cannot be solved using the available computational resources, for example because of memory limitations, to nodes with a higher specification that are not always available to us.

In the absence of global symmetry breaking constraints that can affect different parts of the search tree, it is easy to subdivide a typical CSP into several non-overlapping sub-problems. Although there is an inherent latency in sending problem instances to, and receiving solutions from, either a grid or a cloud, for large enough problems a speedup linear in the number of compute nodes is achieved. Recent results using a computational grid indicate that a super-linear speedup can be achieved using Minion, whenever a root node consistency check reduces the search tree [4]. There is no guarantee of this, however, since root consistency checks are heuristics that will at times provide no benefit for the extra work involved.

Cloud computing is becoming an important computational paradigm, and the Minion developers have produced robust, fault-tolerant, methods for distributing Minion instances across different underlying architectures, including clouds. By leveraging existing technologies, in particular the Condor distributed computing framework [23], we can distribute problems across hundreds of CPUs and combine cluster, grid and cloud architectures for web-scale computing. This enables us to tackle problems which have previously been thought to be unsolvable because of the amount of computation required to find a solution.

## 3.2 Distributed Closest String

Algorithm 2 describes our approach to the distributed solution of closest string problems formalised as Constraint Satisfaction problems. We first run Minion on the original problem with the PWM ordering