
## 3.3 Preliminary Evaluation Of Distributed Closest String

For a first evaluation, we ran the algorithm on 6 random strings of lengths 25, 26, 27, 28, 29 and 30. We chose a time limit of 1 hour to reduce communication overheads. The problems with strings of length 25, 26 and 27 were solved to completion within this limit.

The remaining three instances were split after one hour and distributed across multiple machines. As suggested by Figure 3, the solutions converged towards the optimal distance extremely quickly. For only one of the instances was a better Hamming distance found in one of the sub-instances. The remaining sub-instances proved the optimality of the previously found solution.

These tests demonstrate the practical applicability of our distributed approach. We have not performed a large-scale evaluation, nor have we obtained evidence for the super-linear speedups associated with bounds updates and an increased number of consistency checks at the root of sub-instances. Our experience with the distributed solution of other classes of CSP suggests that our system will scale seamlessly to grids or clouds containing an essentially unlimited number of compute nodes: there is no communication across nodes, a node failure can be recovered from with no extra search needed (the search tree already explored is reported whenever search is interrupted for any reason), and the order in which sub-instances are solved can be tuned.

## 3.4 Hybrid Methods

Input : ϒ
0(S,dmin,HD(S))
TOL, a limit for the gap between the highest and lowest computed distances Output: A closest string to S with its maximum Hamming distance to S
Seek closer distance bounds for ϒ
0(S,dmin,HD(S)) *using* CSP *alone*;
while |dhigh −dlow| < TOL do Run Algorithm 2 on ϒ
0(S,dmin,HD(S))
Output dlow and d*high* when updated end Once bounds are close enough, send to numeric IP or linear time search; if TOL > 1∧|dhigh −dlow| ≤ TOL **then**
Formulate the remaining problem as an Integer Programming problem Search for solution using numeric branch and bound end if |dhigh −dlow| = TOL = 1 **then**
Formulate the remaining problem as a fixed d instance Search for solution using linear time methods end Algorithm 3: Solve the CSP ϒ(S,dmin,HD(S)) using hybrid CSP and numerical methods The empirical results obtained so far suggest that CSP formulation with PWM ordering is an effective approach for ruling out high distances: Minion will often find a first solution very quickly, given the search space involved. However, at least for the approach suggested in this paper, CSP formulation requires much more time to provide a certificate that an optimal solution is indeed optimal. As discussed in Section 1.1, efficient methods have been reported in the literature for when the upper and lower distance bounds are close [17], and for problems where the distance is fixed [11]. In this Section we propose a hybrid approach that aims to take advantage of the best methods available. Algorithm 3 takes a closest string instance and partially solves it using Algorithm 1. If the upper and lower bounds come to within a