identify the strengths and weaknesses of existing numeric approaches, and suggest hybrid discrete and numeric methods that combine the best features of CSP search and numeric search for solutions.

In the rest of this introduction we discuss existing methods for the CSP with respect to theoretical complexity results, give brief overviews of Constraint Satisfaction theory and the Minion CSP solver, and formally define the theoretical concepts upon which the research is based. In Section 2 we model closest string problems as CSPs, compare search heuristics, and provide results for the all closest string problem. We describe distributed algorithms in Section 3, both for pure CSP models and heuristics, and for hybrid CSP-numeric methods. In Section 4 we discuss the relative strengths and limitations of CSP
as a framework for closest string identification, and identify future avenues of research.

## 1.1 Computational Complexity And Existing Methods

CSP has been shown to be NP-complete for binary strings [9] and for alphabets of arbitrary size [14].

Intuitively there are |Σ| choices for each of the L positions in any candidate closest string where Σ is the alphabet, and for any algorithm that fails to check each of this exponential number of cases one could devise a CSP for which the algorithm returns an incorrect result.

Approximate solutions to within (4/3+ε) of the minimal d can be obtained in polynomial time [14, 16], with several practically useful implementations available, notably those based on genetic algorithms [13]. However, in this paper we are concerned with first finding exact solutions, and then (given that we know the minimal distance d) finding all closest strings that are within d of S. Clearly, an approximate method will not, in general, identify the minimal d, and therefore can not be used as a basis for finding all solutions.

Excellent exact results - provided that close bounds have already been identified - have been obtained by modelling the CSP as an Integer Programming Problem [17], and solving the resulting instances using numerical branch and bound methods [15]. This form of search differs from the backtrack search used by CSP solvers by having a much less organised search pattern. This is often advantageous, but can be a hindrance when searching for all solutions: IP branch and bound is optimised for optimisation, as it were, rather than exhaustive search for all candidates for a constant objective function. If the IP formulation suggested in [17] is used, then the feasible region deliberately excludes optimal solutions in order to reduce the numbers of variables, in which case no search for all solutions can be made.

A linear time algorithm exists for solutions to the CSP for fixed distance d [11]. The exponential complexity is now in the coefficient, as the method is O(NL +Nddd) where the problem has N strings of length L.

## 1.2 Constraint Satisfaction Problems

Definition. A Constraint Satisfaction Problem ϒ is a set of constraints C acting on a finite set of variables ∆ := {A1,A2,...,An}, each of which has a finite domain of possible values Di:= D(Ai) ⊆ Λ. A
solution to ϒ is an instantiation of all of the variables in ∆ such that no constraint in C *is violated.*
The class of CSPs is NP-complete as it is a generalisation of propositional satisfiability (SAT). The Handbook of Constraint Programming [21] provides full details of CSP theory and techniques. A key observation is that different models (i.e. choices of variables, values and constraints) for the same problem (or class of problems) will often give markedly different results when the instances are solved, but, as with numeric Linear, Mixed-Integer and Quadratic Programming, there is no general way to decide in advance which candidate models and heuristics will lead to faster search.

A typical solver operates by building a search tree in which the nodes are assignments of values to variables, and the edges lead to assignment choices for the next variable. If a constraint is violated at any node, then search backtracks. If a leaf is reached, then all constraints are satisfied, and the full