
| optimal   | PWM Restricted Domains   | Unrestricted Domains   |                        |                       |               |                |
|-----------|--------------------------|------------------------|------------------------|-----------------------|---------------|----------------|
| ID        | Search                   | distance               | Solutions  CPU seconds | Solutions CPU seconds |               |                |
| Nodes     | Nodes                    |                        |                        |                       |               |                |
| SDF       | 206                      | 397                    | 95,728,551             | 206                   | 1,014         | 2,977,952,054  |
| E02       | 13                       |                        |                        |                       |               |                |
| PWM       | 206                      | 259                    | 79,605,146             | 206                   | 12,938        | 3,840,568,600  |
| SDF       | 10,126                   | 298                    | 7,544,318              | 1,025                 | 16,901        | 4,692,280,693  |
| E04       | 13                       |                        |                        |                       |               |                |
| PWM       | 10,126                   | 240                    | 6,637,501              | 1,025                 | 15,226        | 4,112,428,302  |
| SDF       | 4,404                    | 54                     | 12,908,812             | 4,818                 | 6,161         | 1,443,887,962  |
| E07       | 12                       |                        |                        |                       |               |                |
| PWM       | 4,404                    | 37                     | 9,701,378              | 4,814                 | 5,005         | 1,237,605,802  |
| SDF       | 62,833                   | 155                    | 48,666,288             | 78,698                | 10,238        | 3,646,312,512  |
| E14       | 13                       |                        |                        |                       |               |                |
| PWM       | 62,833                   | 126                    | 36,868,400             | 78,698                | 9,117         | 2,739,528,559  |
| SDF       | 18,706                   | 1,934                  | 520,336,798            | 19,388                | 56,767        | 14,835,210,125 |
| E15       | 14                       |                        |                        |                       |               |                |
| PWM       | 18,706                   | 1,817                  | 474,335,581            | 19,388                | 52,616        | 13,893,247,916 |
| SDF       | 131,501                  | 66,372,957             | 160,121                | 15,130                | 4,474,505,712 |                |
| 261       |                          |                        |                        |                       |               |                |
| E21       | 13                       |                        |                        |                       |               |                |
| PWM       | 131,501                  | 54,102,156             | 160,121                | 1,892                 | 3,360,696,077 |                |
| 199       |                          |                        |                        |                       |               |                |

Figure 4: Empirical data from 6 instances of 5 randomly generated strings of length 25. SDF and PWM
indicate smallest domain and position weight heuristics respectively.  All timings were calculated using a dual quad-core 2.66 GHz Intel X-5430 processor with 16 GB of RAM.

## 2.3 All Closest Strings

To our knowledge, no study has investigated the problem of finding all closest strings for a given set S.

This may be due to the additional computational complexity involved: it is hard enough to find single exact closest strings without performing a systematic search for all such strings having the same maximum distance from S. It may also be the case that the problem is not interesting: the important information in a CSP solution being the distance returned, with the closest string being merely an exemplar at that distance. It seems likely, however, that knowledge of how much self similarity an input set has - rather than just the degree of self similarity - could be useful information in sequence analysis.

Despite this uncertainty, we wish to investigate the effect that modelling has on the set of all solutions.

In our CSP model described in Section 2 we reduce the search space for a first solution by forbidding any variable to take a value that is not present at that position in one of the input strings. Similar restrictions were made by Meneses et al.  when formulating CSP as an Integer Programming problem [17].  The questions are:
1. Are many otherwise closest strings ruled out by these restrictions?

2. How much extra computational effort is required to identify each and every closest string?
In Figure 4 we show the results of sample calculations for six instances of 5 randomly generated strings of length 25 . We see that in all cases (columns headed PWM Restricted Domains) it is relatively easy using Minion to identify all closest strings if we restrict search to those alphabet symbols that have non-zero values in the position weight matrix for the instance. We also find that search using PMW ordering heuristics performs marginally better than straightforward smallest domain heuristics.

When the variable-value assignments that have been ruled out because the value does not appear at the variable's position in any element of S are added back to the domains of the search variables, we can perform full search for all closest strings (Figure 4, columns headed by Unrestricted Domains). The percentage of new closest strings found ranges from 0% to 22%, but increase in search required is typically two orders of magnitude. It should be noted however that:
1. Minion is searching far fewer than the 4 25 possible search nodes for each instance, the majority being pruned by efficient propagation of the logical consequences of the variable-value assignments