# Joint Structured Models For Extraction From Overlapping Sources

Rahul Gupta IIT Bombay, India grahul@cse.iitb.ac.in Sunita Sarawagi IIT Bombay, India sunita@cse.iitb.ac.in

## Abstract

We consider the problem of jointly training structured models for extraction from sources whose instances enjoy partial overlap. This has important applications like user-driven ad-hoc information extraction on the web. Such applications present new challenges in terms of the number of sources and their arbitrary pattern of overlap not seen by earlier collective training schemes applied on two sources. We present an agreement-based learning framework and alternatives within it to trade-off tractability, robustness to noise, and extent of agreement. We provide a principled scheme to discover low-noise agreement sets in unlabeled data across the sources. Through extensive experiments over 58 real datasets, we establish that our method of additively rewarding agreement over maximal segments of text provides the best trade-offs, and also scores over alternatives such as collective inference, staged training, and multi-view learning.

## 1 Introduction

This paper addresses the problem of training multiple structured prediction models that share an output space but differ in their input data and feature space. Further, labeled data in each source is limited, but unlabeled data over the different sources overlap partially. This scenario is applicable in many text modeling tasks such as information extraction, dependency parsing, and word alignment. These tasks are increasingly being deployed in settings where supervision is limited but redundancy is abundant. A concrete motivation for our work comes from recent efforts to support rich forms of structured query-answering on the Web [5, 4]. A typical subtask here is building extraction models over multiple Web documents starting from a small seed of user-provided structured records.

Recently, many learning paradigms have been proposed to exploit the relatedness of multiple models. On one end of the spectrum we have collective inference [21, 3, 15, 8, 12] where each model is trained independently but prediction happens jointly to encourage agreement on overlapping content. On the other end are methods like multi-view learning [11, 9] and agreement-based learning [17, 18] that formulate a single objective to jointly train all models. Then there are methods in-between that train models sequentially or alternately [2, 5]. Our problem is different from traditional multi-view learning where multiple models are trained on different views of a *single* data source. However, by treating the different contexts in which each shared portion resides as a different view, we can apply multi-view learning to this problem. We elaborate on this and other alternatives in Section 4.

In agreement-based learning [17, 18] the goal is to train multiple models so as to maximize the likelihood of the labels agreeing on shared variables. However, these assume that all models need to agree on the same set of variables - this trivially holds for two sources where these methods have been applied. In our application the number of sources is often as large as 20. As number of sources increase, there is a bewildering number of ways in which they overlap. This makes it challenging to devise objectives that maximally exploit the overlap while accounting for noise in the agreement set and intractability of training. We are aware of no study where such issues are addressed in the context of jointly training more than two sources with partial overlap.

In this paper we propose an agreement-based model for training multiple structured models with arbitrary partial overlap among the sources. We propose several alternatives for enforcing agreement ranging from singleton variables, to groups of contiguous variables, to global models that lead to giant agreement graphs. For the task of information extraction, we present a strategy for selecting the unit of agreement that leads to a significant reduction in the noise in the agreement set compared to the existing na¨ıve approach for choosing agreement sets. We present an extensive evaluation on 58 real-life collective extraction tasks covering a rich spectrum of