
## 2.3 Approximations

We explore two categories of approximations for training when LL(A,W) is intractable.

## 2.3.1 Partitioning The Agreement Set

The first category is based on approximating the Pr(YA) distribution with product of simpler distributions obtained by partitioning the set A. We partition the agreement set A into smaller subsets A1*, . . . ,* AR such that each P(YAk
) is easy to compute and ∩kYAk = YA. We then approximate Pr(YA) by Qk P(YAk
), thus replacing the corresponding log-likelihood term by Pk LL(Ak,W). We explore three such partitionings:

Clique Agreement In this case we have one partition per clique C ∈ A. GA now decomposes into several
simpler graphs, where a simple graph has its nodes fused only at one clique. Figures 1(c)-(f) illustrate this
decomposition for the fused model of Figure 1(b). The probability Pr(Y{C}) of agreement on members of a
single clique C simplifies to
$$\operatorname*{Pr}(\mathcal{Y}_{\{C\}})=\sum_{\mathbf{y}\in\mathbf{Y}_{C}}\prod_{(s,i,r)\in C}\operatorname{P}_{s}(\mathbf{Y}_{s i r}=\mathbf{y}|\mathbf{X}_{s i})$$
Ps(Ysir = y|Xsi) (10)

where YC is set of all possible labelings for any member of C, and Ps(Ysir = y) is the marginal probability of the part r taking the labeling y under Ps.

This approximation is useful for two reasons. First, if the base models are sequences (e.g. in typical extraction tasks) and clique parts r are over contiguous positions in the sequence, the fused graph of Pr(Y{C}) is always a tree, such as the ones in Figures 1(c)-(f). Second, since for trees we can use sum-product to compute Pr(Y{C})
instead of Equation 10, we can now use arbitrarily long cliques, instead of choosing unigram cliques which is typically the norm in extraction applications.

Node Agreement We also consider a special case of the clique agreement approximation, called node agreement, in which each partition corresponds to agreement over a single variable as in Figure 1(e).

Instance Pair Agreement Another decomposition is based on picking pairs of instances and defining an agreement set on all cliques which they share. For the example in Figure 1, graphs marked (g),(h),and (i)
demonstrate the fused graphs arising out of instance pair agreement. This scheme is expected to be useful when base models exhibit strong edge potentials. However, unlike for the above two decompositions, there is no guarantee that the fused graph is a tree (e.g. graph (g)). So, approximate inference may be required for some pairs.

## 2.3.2 Approximating Za(Θ)

An alternate way to approximate LL(YA,W) is to stick with the fused model but approximate the computation of ZA(θ). We consider two options:
Full BP In general, any available sum-product inference algorithm like Belief Propagation and their convergent tree reweighted versions [20, 14] can be used for approximating ZA(θ). However, these typically require multiple iterations and can be sometimes slow to converge.

OneStep TRW [17] propose a one-step approximation that reduces to a single step of the Tree reweighted
(TRW) family of algorithms [14] where the roles of trees are played by individual instances. As in all TRW algorithms, this method guarantees that the log partition value it returns is an upper bound, but for maximization problems upper bounds are not very useful.

A downside of these approaches is that there is no guarantee that the approximation leads to a valid probability distribution. For example, we often observed that the approximate value of P
ZA(θ) was greater than s,i log Z(Xs,i, ws) causing the probability of agreement to be greater than 1.

To summarize, we would ideally like to optimize the agreement-based objective in Equation 6 exactly by working with the equivalent fused graphical model of Equation 9. Due to intractability, we discussed various ways to decompose the agreement term or approximate the corresponding fused model. As we shall show in