Section 5, when there are noisy cliques in the agreement set, the tractable decompositions turn out to be much more robust than methods that approximate the fused model created from erroneous cliques.

## 3 Generating The Agreement Set

In this section we discuss our unsupervised strategy for finding agreement sets. But first we stress that the importance of this step cannot be overstated. As we show in Section 5, even the best collective training schemes are only as good as their agreement set. This has interesting parallels with other learning tasks e.g. semisupervised learning, where recent work has shown the importance of creating good neighborhood graphs [13].

Traditional collective extraction methods have not focused on the process of finding quality agreement sets.

These methods usually form a clique from arbitrary repetitions of unigrams [21, 8, 15]. This is inadequate because of two reasons. First, any strong first order dependencies cannot be transferred with only unigram cliques. Second, blindly marking repetitions of a token/n-gram as a clique can inject a lot of noise in the agreement set.

Instead we use a more principled strategy. We make the working assumption that significant content overlap among sources is caused by (approximate-)duplication of instances. So we assume that each instance has a hidden variable with value equal to its 'canonical instance value'. Instances inside a source will have different values of this variable (as duplicates are rare inside a source), whereas these values will be shared across sources, thus forming clusters. Assume for now that these clusters are known. Given such a cluster of deemed duplicates, we find maximally long segments that repeat among the instances in the cluster, and add one clique per such segment to the agreement set. Segment repetitions outside the cluster are considered as false matches and ignored.

The task of optimally computing the clusters essentially reduces to the NP-hard multi-partite matching problem with suitably defined edge-weights. We tackle this by employing the following staged scheme: First, we order the sources using a natural criteria such as average pairwise similarity with the other sources. Each instance in the first source forms a singleton cluster. In stage s, we find a bipartite matching between source s + 1 and the clusters formed by the first s sources. An instance i in source s + 1 will be assigned to the cluster to which it is matched. Unmatched instances form new singleton clusters. The edge-weight between an instance i and a cluster is defined as the best similarity of i with any member instance of the cluster.

When our assumption of instance duplication does not hold, say when each instance is an arbitrary natural language sentence, the bipartite matching scores will be low and we revert to the conventional clique generation scheme. As we shall see in Section 5, our strategy generates much better agreement cliques in practice.

## 4 Relationship With Other Approaches

We now review various approaches relevant to collective training with partially overlapping sources. We omit Agreement-based learning as it has already been discussed in Sections 1 and 2.3.

## 4.1 Posterior Regularization (Pr)

The PR framework [10] trains a model with task-specific linear constraints on the posterior. The constrained optimization problem is solved via the EM algorithm on its variational form. PR has been shown to have interesting relationships with similar frameworks [16, 19, 6].

The aspect of PR most relevant to us is its application to multi-view learning [11]. Then the PR constraints translate to minimizing the Bhattacharayya distance between the various posteriors. This has two key differences with our setting. First their agreement set is at the level of full instances instead of arbitrary sub-parts. Moreover, their agreement set has no noise because the instances across views are known duplicates instead of assumed ones like in ours. The second and more interesting difference is that of the agreement term.

Assuming that we have only two sources s and s 0, with only one shared clique c, training the two models is the same as learning in the presence of two-views of c. The agreement term under PR would be log Pyc pPs(yc)Ps 0 (yc), where P.(yc) is the marginal of c. This is maximized when the two marginals are identical. In contrast, our agreement term of log Pyc Ps(yc)Ps 0 (yc) is maximized when the marginals are identical *and peaked*. If both the base models are strong, their marginals will be almost peaked, resulting in little