putable function is the uncomputable propositional function (predicate) that determines whether a computable partial function is a total function. The development of computer programs provides a model for the evaluation of this uncomputable predicate because, for example, a program must produce an output for any input for which the program is defined.

How can we use our insight into the nature of Turing's residue, in particular, into the evaluation of uncomputable functions to implement a creative machine? Turing [1969] **writes: "Our task is to discover the nature of this**
residue as it occurs in man, and to try and copy it in machines." According to our hypotheses we must choose a programming language and implement knowledge about this language, for example, the domains and ranges of the elementary functions or instructions it contains. In order to reduce the complexity of a first implementation we should reduce the number and complexity of the informal concepts to be implemented. A concrete project might aim to prove theorems in a mathematics textbook on the basis of preceding theorems and proofs (see Ammon 1988). According to our approach no formal system, which eliminates Turing's residue, should be used but the ordinary representation of theorems and proofs should be modeled. Another possible field of application might aim at an automatic development of programs. An implementation of a creative machine would be general and complete if it can change all its source code and develop new knowledge from scratch, that is, from a universal programming language. Obviously, Ammon [1988] **is far**
from a general and complete system in our sense.

The theorems and hypotheses on creative machines have epistemological implications. For example, informal concepts such as computable functions are extensible beyond any formal limits. Because a creative machine can construct and revise any knowledge starting from any programming language and any input there is only a rather limited general description of its structure and development, in particular, its starting point. This is comparable **with**
Piaget's [1970, p. 704] **view: "Knowledge, then, at its origin, neither arises**
from objects nor from the subject, but from interactions - at first inextricable - between the subject and those objects."

## 6 Related Work

Ordinarily, the word "machine" refers to a Turing machine which is a formalization of the concept of an algorithm or effective procedure **(see Hopcroft**