In view of Theorem 3 creative machines can process the informal concept of computable functions beyond the limits of any given Turing machine. In particular, the effective procedure P **in the theorem can be regarded as a bridge**
to this informal concept, that is, to Turing's uncomputable "residue". The next section introduces hypotheses on the development of creative machines and their mode of operation. The hypotheses provide more information on the nature of Turing's "residue".

## 4 Hypotheses

Let P **be a computer program whose properties are not known, that is, we**
have no or only partial knowledge about P. We can apply P **to an input,**
for example, the natural number 1, which may produce the natural number 2. Thus, the execution of P **produces knowledge which can be represented**
in function notation by P(1) = 2. (2)
We may apply the program P **to another input, for example, the natural**
number 2, which may produce the natural number 3, that is, the knowledge

$$P(2)=3.$$
$\left(4\right)$. 
P(2) = 3. (3)
From (2) and (3), we may assume by fallible inductive reasoning that

$$P(n)=n+1$$
P(n) = n **+ 1 (4)**
holds for all natural numbers n**. This simple example illustrates how knowledge about a program can be produced by the execution of the program and**
fallible inductive reasoning.

In order to develop a computer program a programmer usually applies all available knowledge. When the program is written, he tests it to verify whether it has the desired properties, that is, he has only partial knowledge about the program. In his tests he executes the program which produces further knowledge, for example, whether it generates an output from any input.

Finally, he concludes on the basis of the tests and all available knowledge that the program has the desired properties. This conclusion can be regarded as fallible inductive reasoning. Thus, program development usually involves the application of all available knowledge, the execution of the program in **tests**