# A Two-Step Fusion Process For Multi-Criteria Decision Applied To Natural Hazards In Mountains

Jean-Marc Tacnet Cemagref-ETNA
2, rue de la pap`eterie B.P. 76 38402 Saint Martin d'Heres Cedex, France Email: jean-marc.tacnet@cemagref.fr Mireille Batton-Hubert EMSE - SITE
29, rue Ponchardier 42100 Saint-Etienne, France Email: batton@emse.fr Jean Dezert ONERA
29, avenue de la division Leclerc B.P. 72 92322 Chˆatillon Cedex, France Email: jean.dezert@onera.fr Abstract—Mountain river torrents and snow avalanches generate human and material damages with dramatic consequences.

Knowledge about natural phenomenona is often lacking and expertise is required for decision and risk management purposes using multi-disciplinary quantitative or qualitative approaches. Expertise is considered as a decision process based on imperfect information coming from more or less reliable and conflicting sources. A methodology mixing the Analytic Hierarchy Process (AHP), a multi-criteria aid-decision method, and information fusion using Belief Function Theory is described. Fuzzy Sets and Possibilities theories allow to transform quantitative and qualitative criteria into a common frame of discernment for decision in Dempster-Shafer Theory (DST ) and *Dezert-Smarandache* Theory (DSmT **) contexts. Main issues consist in basic belief assignments**
elicitation, conflict identification and management, fusion rule choices, results validation but also in specific needs to make a difference between importance and reliability and uncertainty in the fusion process.

Keywords: natural hazards, expertise, decision-making, multi-criteria decision making, Analytic Hierarchy Process (AHP), DST, DSmT.

## I. Introduction

Mountain river torrents and snow avalanches generate human and material damages with dramatic consequences. In

![0_image_1.png](0_image_1.png)

the natural hazards context, risk is assessed as a combination of hazard and vulnerability levels. This formulation can be considered as equivalent to a combination of frequency and gravity which is more currently used in industrial context (figure 1).

Expertise is always required to define the types of possible phenomena, to assess the hazard and risk levels and to propose prevention measures. Expert judgements depend on quality and uncertainty of the available information that may result

![0_image_0.png](0_image_0.png)

from measures, historical analysis, testimonies but also subjective, possibly conflicting, assessments done by the experts themselves. As an example, the definition of risks zones is often based on the extrapolation of historical information known on particular points using morphology based analysis
(figure 2).

At the end, phenomenon scenarios and decisions may very well rely on very uncertain information without being able to really know what was completely true, imprecise, conflicting or simply unknown in the hypotheses leading to these results. In that context, our essential hypothesis consists in considering expertise as a decision process based on imperfect information related to multiple criteria and coming from more or less reliable and conflicting sources.

This paper proposes a methodology able to help decision based on imperfect information. In section II, we briefly introduce the principles of multi-criteria decision analysis (**MCDA**) focusing on the AHP developed by T. Saaty
(section II-A). The section II-B analyzes the existing methods methods using both **MCDA** methods and theories for uncertainty management. In section III, we present the different steps of a new methodology applying to a multi-criteria deci-