
## 5.2 Representation Of Knowledge

The construction of rational functions can be performed in different ways. Of course, one can define rational functions as pairs of polynomials. On the other hand there is the possibility to construct (the field of) rational functions as the completion of polynomial rings. Though the second version is mathematically more challenging we decided to use pairs. We wanted to emphasize the **contribution to applications by concentrating on prior knowledge of potential users:**
Electrical engineers are probably not interested in (working with!) abstract algebra, their interests and needs are different.

In the same context there is another representational problem: **In MML we**
find both the complex numbers and the field of complex numbers. Not **a problem** in itself, this may cause some confusion when searching for notions and theorems:
The functors Re and ⁀ Im **giving the real and imaginary part, for exmaple, are**
defined for complex numbers only, thus - theoretically - not applicable to elements of a field. In Mizar, however, this is not necessarily the case: Using a special registration - identify **[Kor09] - the user can identify terms and**
operations from different structures, here complex numbers with **elements of the** field of complex numbers:

## Registration

let a,b be complex number; let x,y be Element of F_Complex; identify x+y with a+b when x=a, y=b; identify x*y with a*b when x=a, y=b; end; In effect, after this registration functors Re and ⁀ Im **are applicable to elements**
of the field of complex numbers.

In general, different views on mathematical objects - here, complex numbers as numbers or elements of a field - have to be handled carefully in mathematical repositories in order to not confuse possible users. Even the rudimentary difference between a polnomial and its polynomial function can lead to **surprises**
and incomprehension for people not familiar with the formal treatment of mathematics in repositories.

## 5.3 Applicability Of Knowledge

As we have already seen, the adaption of general knowledge in MML to special cases is straightforward: One just instantiates parameters describing the general domain with the special one, so for example Polynomial of F_Complex for polynomials over the (field of) complex numbers.

This, on the other hands, means that to work with such instantiations the user has to apply theorems about the general structure. Though highly desirable from the mathematical point of view, it is not clear whether this is really convenient for application users: To work in the special field of complex numbers, for example, then means to search for helpful theorems in the theory of fields, rings