For physically realizable LTI systems, such as the class of networks with constant and concentrated parameters, H(s**) is given in form of a rational function**
with real coefficients, that is

$$H(s)=\frac{a_{n}s^{n}+\ldots+a_{0}}{b_{m}s^{m}+\ldots+b_{0}},\quad a_{i},b_{i}\in\mathbb{R}.\tag{1}$$

In this case the region of convergence can be described by the roots of the denominator polynomial: If si = σi +jωi for i = 1, . . . m **are the roots of** bms m +
. . . + b0**, the region of convergence is given by**

$$\left(4\right)$$

ℜ{s} > max{σi, i = 1**, . . . m**}.

To check stability it is therefore sufficient, to show that the real part ℜ{s} of all poles of H(s) is smaller then 0. The denominator of H(s**) is thus a so-called** Hurwitz polynomial.

Note that the stability problem for discrete-time signals and systems can be analized with the same approach. For a given discrete-time transfer function H(z) in the Z**- domain, it has to be checked whether the unit circle is contained**
in the region of convergence. Hence for all poles zi of H(z**) we must have** |zi| < 1.

Using bilinear transformations [OS98]

$$z\;:=\;{\frac{1+s}{1-s}}.$$
$$\left(5\right)$$

. (5)
it is thus sufficient to check whether the denominator of

$${\mathrm{matter~of~}}$$
$\left(\mathrm{6}\right)$. 
H(z)|z:= 1+s 1−s(6)
is a Hurwitz polynomial.

The practical proof of stability of high-precision filters, however, **turns out**
to be very hard. In practical applications the poles of concern are **usually close**
to the axis s = jω **or the unit circle** |z| = e jω **respectively. Thus numerical**
determination of the poles is highly error-pruning due to its rounding **effects. In** digital signal processing in addition degrees of transfer functions **tend to be very** high, for example 128 and higher in communication networks.

An interesting and in practice often used method to check the stability of a given network is based on the following theorem.

## Theorem 1. **([Unb93])**

Let f(x) be a real polynomial with degree n ≥ **1. Furthermore let all coefficients**
of f(x) be greater than 0. Let fe(x) and fo(x**) denote the even part resp. the**
odd part of f(x**). Assume further that**

$$Z(x)\ =\ {\frac{f_{e}(x)}{f_{o}(x)}}$$

or the reciprocal of Z(x) is a reactance one-port function of degree n**. Then** f(x) is a Hurwitz polynomial.