Gabora, L. (2010). Recognizability of individual creative style within and across domains: Preliminary studies. In S. Ohlsson & R. 

Catrambone (Eds.), Proceedings of the 32nd Annual Meeting of the Cognitive Science *Society* (pp. 2350-2355). Austin, TX: 
Cognitive Science Society.

# Recognizability Of Individual Creative Style Within And Across Domains: Preliminary Studies

Liane Gabora **(liane.gabora@ubc.ca)** 
Department of Psychology, University of British Columbia Okanagan campus, 3333 University Way Kelowna BC, V1V 1V7, CANADA 

## Abstract

It is hypothesized that creativity arises from the self-mending capacity of an internal model of the world, or worldview. The uniquely honed worldview of a creative individual results in a distinctive style that is recognizable within and across domains. It is further hypothesized that creativity is domaingeneral in the sense that there exist multiple avenues by which the distinctiveness of one's worldview can be expressed. These hypotheses were tested using art students and creative writing students. Art students guessed significantly above chance both which painting was done by which of five famous artists, and which artwork was done by which of their peers. Similarly, creative writing students guessed significantly above chance both which passage was written by which of five famous writers, and which passage was written by which of their peers. These findings support the hypothesis that creative style is recognizable. Moreover, creative writing students guessed significantly above chance which of their peers produced particular works of art, supporting the hypothesis that creative style is recognizable not just within but across domains. 

Keywords: art; creative writing; creativity; Darwinian theory; expertise; heuristic search; honing; style; voice.

## Introduction

The therapeutic nature of the creative process is well known. Eminent creators and laypeople alike often claim that through engagement in creative activities they gain a clearer sense of themselves as unique individuals. By making artistic choices, and observing how these choices guide subsequent thoughts about the work, eventually culminating in original, creative form, they acquire selfknowledge, and often, are left with a sense of completeness. 

The transformation that occurs on canvas or on the written page is said to be mirrored by a sense of personal transformation and self-discovery that occurs within. 

Artists often find a style that feels as if it is 'theirs' only after periods of exploration with different media and established styles and art forms. Similarly, writers speak of transitioning from a stage in which they were merely imitating the styles of authors they admired to a stage in which they discovered their own authentic 'voice'. This sense of self-discovery may seem to the creator as real as anything he or she has ever experienced, and the transition from merely imitating others to finding one's own identifiable style is often evident to anyone exposed to an individual's creative works. But although the phenomenon of recognizable creative style seems obvious to artists themselves, and to those who appreciate what they do, it is not predicted by well-known theories of creativity.

This paper presents the results of preliminary experiments designed to test the hypothesis that creative individuals possess a distinctly recognizable creative style, and that this creative style is recognizable not just within a domain but across domains. We begin by discussing by well-known theories of creativity, and how the phenomena of individual style and 'voice' are not predicted by them. Three studies are then presented. The first two studies test the hypothesis that the phenomenon of creative style is real; that is, that creative individuals such as artists and writers genuinely exhibit a creative style that others come to associate with them. The third study tests the hypothesis that an individual's creative style is recognizable not just in one domain, but across different domains. Finally, we discuss how the findings are compatible with a new theory of creativity. 

## Theories Of Creativity

This section very briefly summarizes some leading theories of how the creative process works, and then presents a new theory of creativity referred to as honing theory. 

## Creativity As Heuristic Search

Inspired by the metaphor of the mind as a computer (or computer program), it was proposed that creativity involves a process of heuristic search, in which rules of thumb guide the inspection of different states within a particular state space (set of possible solutions) until a satisfactory solution is found (Eysenck, 1993; Newell, Shaw & Simon 1957; Newell & Simon 1972). In heuristic search, the relevant variables are defined up front; thus the state space is generally fixed. Examples of heuristics include breaking the problem into sub-problems, hill-climbing (reiteratively modifying the current state to look more like the goal state), 
and working backward from the goal state to the initial state. A variation on this is the view that creativity involves heuristics that guide the search for, not a possibility within a given state space, but a new state space itself (*e.g.,* Boden, 1990; Kaplan & Simon, 1990, Ohlsson, 1992). That is, it involves switching from one representation of the problem to another, sometimes referred to as *restructuring* (Weisberg, 1995). 

## The Expertise View Of Creativity

Some posit that creativity involves everyday thought processes such as remembering, planning, reasoning, and restructuring; no special or unconscious thought processes 