need be postulated (Perkins, 1981; Weisberg, 2006). This is sometimes referred to as the *expertise view* of creativity because it stresses the extent to which creative acts draw upon familiarity with a particular domain of knowledge. 

Thus this view in particular is associated with the notion that creativity is highly domain-specific; expertise in one domain is not viewed as enhancing creativity in another domain. The expertise view is also associated with the notion that the creative process result in products that are largely derivative, or *reproductive* (as Weisberg puts it), as opposed to genuinely new, or *productive*.

## The Darwinian Theory Of Creativity

Another approach to modeling the creative process involves framing it in Darwinian terms. While some philosophers describe the growth of knowledge as Darwinian merely in the sense that conjectures must be refutable, *i.e.*, able to be selected against (Popper, 1963; Lorenz, 1971), Campbell 
(1960) goes further, arguing that a stream of creative thought is a Darwinian process. The basic idea is that we generate new ideas through 'blind' variation and selective retention (abbreviated BVSR): 'mutate' the current thought a multitude of different ways, select the fittest variant(s), and repeat this process until a satisfactory idea results. The variants are 'blind' in the sense that the creator has no subjective certainty about whether they are a step in the direction of the final creative product. 

Currently the Darwinian view of creativity is most closely associated with Simonton (1998, 1999a,b, 2007a,b), who views creativity as essentially a trial-and-error process in which the most promising 'blindly' generated ideational variants are selected for development into a finished product. It should be noted that the endeavor to apply natural selection to creative thought is not without critics 
(Dasgupta, 2004; Eysenck, 1995; Gabora, 2005, 2007; Sternberg, 1998, Thagard, 1980; Weisberg, 2000, Weisberg 
& Haas, 2007). Nevertheless, the development of a creative idea can be said to be evolutionary in the very general sense that it exhibits descent with adaptive modification.

## The Honing Theory Of Creativity

Central to the *honing theory* of creativity is the notion of a worldview, by which we mean one's internal model of the world, as well as one's values, attitudes, predispositions, and habitual patterns of response (Gabora, 2000, 2004, 2008, Gabora & Aerts, 2009). Honing theory posits that creativity arises due to the *self-organizing, self-mending* nature of a worldview, and that it is by way of the creative process the individual hones (and re-hones) an integrated worldview. Honing theory places equal emphasis on the externally visible creative outcome and the internal cognitive restructuring brought about by the creative process. Indeed one factor that distinguishes it from other theories of creativity is that it focuses on not just restructuring as it pertains to the conception of the task, but as it pertains to the worldview as a whole. When faced with a creatively demanding task, there is an interaction between the conception of the task and the worldview. The conception of the task changes through interaction with the worldview, and the worldview changes through interaction with the task. This interaction is reiterated until the task is complete, at which point not only is the task conceived of differently, but the worldview is subtly or drastically transformed. Thus one distinguishing feature of honing theory is that the creative process reflects the natural tendency of a worldview to seek integration or consistency amongst both its pre-existing and newly-added components, whether they be ideas, attitudes, or bits of knowledge; it mends itself as does a body when injured.

## The Recognizability Of Creative Style

Theories of creativity based on heuristic search, the acquisition of expertise, or chance, random processes, such as BVSR, give no reason to expect that the act of creation leads to a clearer or more integrated sense of self, or that the works of a particular creator should exhibit a unique and recognizable style. This is particularly so if, as is often claimed, creativity is strongly domain-specific (Baer, 1998; Sawyer, 2006; Weisberg, 2006). If creativity is limited to a particular domain then why should it result in a global sense of wellbeing or integration? 

Claims about the domain-specificity of creativity are based largely on findings that correlations amongst alternative measures of creativity are small, and expertise or eminence with respect to one creative endeavor is rarely associated with expertise or eminence with respect to another (e.g. Getzels & Jackson, 1962). Thus, for example, creative scientists rarely become famous artists or dancers. 

The focus of these studies is squarely on expertise or eminence as evidence of creative achievement. But what if creative achievement is measured not by expertise or eminence but by having found a way to express what is genuine and unique about us through whatever media we have at a given time at our disposal? One might expect that an artist's or scientist's personal style comes through in how he or she prepares a meal or decorates a room, what creativity researchers refer to as little-c (Richards, Kinney, Benet, & Merzel, 1988) or mini-c (Beghetto & Kaufman, 2007) creative activities. Findings of domain-specificity in creativity may have more to do with the fact that we focus on creative achievement at a level that takes a decade or more to obtain (Simonton, 2007), as opposed to looking for evidence that creative potential and personal style transcends particular domains. In other words, looking for evidence of exceptional creativity in multiple domains is not the only or necessarily even the best way to address the question of whether creativity is domain-specific. Another way is to look for evidence that an individual exhibits a creative style in one domain that also 'comes through' when engaged in creative activities in other domains. 

Although the phenomenon of recognizable style or voice is not predicted by the view that creativity is a matter of heuristic search, expertise, or Darwinian selection, it is predicted by the honing theory of creativity. We have seen 