that, according to honing theory, creativity is the process by which one hones a worldview, and each idea the creator comes up with is a different expression of the same underlying core network of understandings, beliefs, and attitudes. A worldview has a characteristic structure, and the creator's various outputs are reflections of that structure, and they are related to one another, and potentially pave the way for one another. Thus honing theory predicts that creative individuals have a recognizable style. 

There is evidence that human creativity is more consistent with honing theory than with competing theories of creativity with respect to developmental antecedents of creativity, personality traits of creative individuals, and studies of lifespan creativity (Gabora, under revision). This paper reports on the results of creative style experiments that provide further support for the theory. The goal of the first two studies was to find empirical evidence for the common belief that there really is such a thing as recognizable style or voice. Although artists have no doubt this is true, it has not been studied by psychologists, and as we have seen, most theories of creativity do not predict it. 

The goal of the third study was to test a more controversial prediction of honing theory, the prediction that the structure of a worldview manifests in a unique and recognizable way, to varying degrees, through *different* creative outlets. Thus for example, you might recognize someone's art by knowing how they dress or decorate.

## Study 1: Within-Domain Recognizability Of Artistic Style

The first study tested the hypothesis that individuals who are highly familiar with the art of a given artist will recognize other works by that artist that they have not encountered before.

## Method

Participants The research was conducted with 10 University of British Columbia undergraduates majoring in art who were highly familiar with five well-known artists, and with each other's art.

Materials and Procedures Prior to the study, participants were instructed to bring from home a recently completed painting that they had never discussed with or shown to any of their classmates. They were asked to hide their signatures or any other identifying feature of the painting. Before the study, the paintings were examined to ensure that signatures and any other identifying features had been covered. 

At the beginning of the study, the art students were shown three well-known paintings by each of five well-known artists as a refresher. The well-known artists were Picasso, Monet, Van Gogh, Dahli, and Andy Warhol. These artists were decided upon because previous discussion with the class indicated that all students were highly familiar with them. The students were then shown ten unfamiliar (rare or newly completed) works that they had not studied in class. 

Signatures on all artworks were covered by black tape. The art students were given a questionnaire and asked to guess which famous artist did each painting. For each answer they were also asked to state how certain they were on a 3-point scale that they had not encountered the work before.

They were also shown the paintings by their fellow classmates that they had never seen before. The rationale for showing classmates' paintings was to control for the possibility that with the well-known artists, a participant who, though not recognizing the creative voice, might guess above chance levels to which era or country the artist belonged. The only sufficiently large number of artists from the same era and locale that the students were familiar with were their own classmates. As with the famous artists, they were asked to guess which classmate did each painting, and to state how certain they were on a 3-point scale that they had not encountered the work before.

The participants were debriefed, and the results were analyzed. If a participant had encountered a work before, or was uncertain about having encountered it before, the score for this question was not included in the analysis. Less than 5% of scores were not included in the analysis.

Analysis The data were analyzed to determine if the participants correctly identified the artists at above-chance levels. First, a proportion correct score for each participant was computed. For example, if a participant correctly identified seven out of 10 possible artists, the proportion correct score for that person was .70. Then, the proportion correct score that would have been obtained on the basis on random guesses for each question was computed. For example, for the well-known artists, since there were 5 of them, the proportion correct based on random guesses was .20. One-sample t-tests were then computed comparing the average proportion correct scores to the proportion correct values that would have been obtained had participants been randomly guessing. A one-sample randomization test 
(Manly, 2007) was used to compute the p-levels for these ttest values, given the small sample sizes, and .05 was used as the criterion for statistical significance.

## Results

The results are divided into two sections: recognition of famous artists, and recognition of classmates' art. 

Recognition of Famous Artists For the task in which art students were asked which famous artist painted each painting, the mean proportion correct was .78 (SD = .12). The proportion correct that would have been obtained on the basis of random guesses was .20. This difference is statistically significant, t(9) = 15.3, p < .0001, r (effect size) = .98. Thus art students were able to distinguish above chance which famous artists created pieces of art they had not seen before. 

Recognition of Classmates' Art A similar result was obtained with works of art by the students themselves. The mean proportion correct was .74 (SD = .29). The proportion 