arXiv:1005.1860v2 [cs.AI] 20 May 2010

# Feature Selection Using Regularization In Approximate Linear Programs For Markov Decision Processes

Marek Petrik* petrik@cs.umass.edu Gavin Taylor† gvtaylor@cs.duke.edu Ron Parr† parr@cs.duke.edu Shlomo Zilberstein* shlomo@cs.umass.edu
* Department of Computer Science, University of Massachusetts, Amherst, MA 01003 USA † **Department of Computer Science, Duke University, Durham, NC 27708 USA**

## Abstract

Approximate dynamic programming has been used successfully in a large variety of domains, but it relies on a small set of provided approximation features to calculate solutions reliably. Large and rich sets of features can cause existing algorithms to overfit because of a limited number of samples. We address this shortcoming using L1 **regularization in**
approximate linear programming. Because the proposed method can automatically select the appropriate richness of features, its performance does not degrade with an increasing number of features. These results rely on new and stronger sampling bounds for regularized approximate linear programs. We also propose a computationally efficient homotopy method. The empirical evaluation of the approach shows that the proposed method performs well on simple MDPs and standard benchmark problems.

## 1. Introduction

Solving large Markov Decision Processes (MDPs) is a very useful, but computationally challenging problem addressed widely by reinforcement learning. It is widely accepted that large MDPs can only be solved approximately. This approximation is commonly done by relying on linear value function approximation, in which the value function is chosen from a small-dimensional vector space of features. While this framework offers computational benefits and protection from the overfitting in the training data, selecting Appearing in Proceedings of the 27 th International Conference on Machine Learning**, Haifa, Israel, 2010. Copyright**
2010 by the author(s)/owner(s).

an effective, small set of features is difficult and requires a deep understanding of the domain. Feature selection, therefore, seeks to automate this process in a way that may preserve the computational simplicity of linear approximation (Parr et al., 2007; **Mahadevan,**
2008). We show in this paper that L1**-regularized approximate linear programs (RALP) can be used with**
very rich feature spaces.

RALP relies, like other value function approximation methods, on samples of the state space. The value function error on states that are not sampled is known as the sampling error**. This paper shows that regularization in RALP can guarantee small sampling error.**
The bounds on the sampling error require somewhat limiting assumptions on the structure of the MDPs, as any guarantees must, but this framework can be used to derive tighter bounds for specific problems in the future. The relatively simple bounds can be used to determine automatically the regularization coefficient to balance the expressivity of the features with the sampling error.

We derive the approach with the L1 **norm, but it could**
be used with other regularizations with small modifications. The L1 **norm is advantageous for two main**
reasons. First, the L1 norm encourages the sparse solutions, which can reduce the computational requirements. Second, the L1 **norm preserves the linearity**
of RALPs; the L2 **norm would require quadratic optimization.**
Regularization using the L1 **norm has been widely**
used in regression problems by methods such as LASSO (Tibshirani, 1996) and Dantzig selector (Candes & Tao, 2007). The value-function approximation setting is, however, quite different and the regression methods are not directly applicable. Regularization has been previously used in value function approximation (Taylor & Parr, 2009; Farahmand et al.,