the remainder of the paper, we make the following standard assumption (Schweitzer & Seidmann, **1985),** which can be satisfied by setting the first column of M to 1.

Assumption 2. For all k ∈ R, we have that k·1 ∈ M,
where 1 **is a vector of all ones.**
For simplicity and generality of notation, we use L to denote the ALP constraint matrix, so Lv ≤ v **is equal**
to the set of constraints {Lav ≤ v : ∀a ∈ A}**. Then,**
we can rewrite the ALP as follows:

$$\begin{array}{r l}{\operatorname*{min}_{v}}&{{}\rho^{\mathsf{T}}v}\\ {\mathrm{s.t.}}&{{}{\mathcal{L}}v\leq v\quad v\in{\mathcal{M}}}\end{array}$$
$$\mathrm{(1)}$$

Notice that the constraints in the ALP correspond to the definition of transitive-feasible functions in Definition 1. A succinct notation of the ALP constraints can then use the set of transitive-feasible functions as v **∈ M ∩ K**.

The constraint v ∈ M implies that v = Φw **and therefore the number of variables in (1) corresponds to the**
number of features. Typically, this is a small number. However, the number of required constraints in ALP is |S| × |A|**, which is oftentimes impractically**
large or infinite. The standard solution is to sample a small set of constraints according to a given distribution (de Farias & Van Roy, **2003). It is then possible**
to bound the probability of violating a randomly chosen constraint. There are, however, a few difficulties with this approach. First, leaving constraints out can lead to an unbounded linear program. Second, in practice the distribution over the constraints can be very different from the distribution assumed by the theory.

Finally, the bound provides no guarantees on the solution quality.

ALP has often under-performed ADP methods in practice; this issue has been recently studied and partially remedied (Petrik & Zilberstein, **2009;**
Desai et al., **2009). Because these methods are independent of the proposed modifications, we only focus**
on standard approximate linear programs. We show next that RALP with sampled constraints not only guarantees that the solution is bounded and provides worst-case error bounds on the value function, but also is independent of the number of features. As a result, the ALP formulation does not require a small number of features to be selected in advance.

## 4. Regularized Approximate Linear Programming

In this section, we introduce L1**-regularized ALP**
(RALP) as an approach to automate feature selection and alleviate the need for all constraints in standard ALP. Adding L1 **regularization to ALP permits the**
user to supply an arbitrarily rich set of features without the risk of overfitting.

The RALP for basis Φ and L1 constraint ψ **is defined**
as follows:
$$\begin{array}{ll}\min&\rho^{\sf T}\Phi w\\ \mbox{s.t.}&{\cal L}\Phi w\ \leq\Phi w\quad\|w\|_{1,e}\leq\psi,\end{array}\tag{2}$$  where $\|w\|_{1,e}=\sum_{i}e(i)w(i)$. Note that RALP is a 
generalization of ALP; when ψ **approaches infinity, the**
RALP solution approaches the ALP solution. The objective value of (2) as a function of ψ **is denoted as**
θ(ψ).

We generally use e = 1−1**, which is a vector of all ones**
except the first position, which is 0; because the first feature is the constant feature, we do not include it in the regularization. The main reasons for excluding the constant feature are that the policy is independent of the constant shifts, and the homotopy method we propose requires that the linear program is easy to solve when ψ **= 0.**
Alternatively, we can formulate RALP in (2) as a minor modification of ALP in equation (1). This is by modifying M to satisfy the L1 **norm as:**

$${\mathcal{M}}(\psi)=\{\Phi w\,\big|\,\|w\|_{1,e}\leq\psi\}.$$

Notice that RALP introduces an additional parameter ψ over ALP. As with L1 **regularization for regression,**
this raises some concerns about a method for choosing the regularization parameter. Practical methods, such as cross-validation may be used to address this issue.

We also propose an automated method for choosing ψ in Section 5 **based on the problem and sampling parameters.**

## 5. Sampling Bounds

The purpose of this section is to show that RALP offers two main benefits over ALP. First, even when the constraints are sampled and incomplete, it is guaranteed to provide a feasible solution. Since feasibility does not imply that the solution is close to optimal, we then show that under specific assumptions
- such as smooth reward and transition functions - RALP guarantees that the error due to the missing constraints is small.