In this contribution, we shall study whether and how the Artificial Gene Regulatory Model proposed in [6] can be used to achieve the function traditionally implemented by control algorithms, by applying it to a classical benchmark problem of control engineering, pole balancing.

Along the way, we hope to learn how to use this type of representation for problems usually solved with less evolvable representations. Our **goal is to**
arrive at a flexible and at the same time very general representation useful in GP in general. While we are not there yet, we have made progress notably by finding ways to couple input and output to artificial GRNs, a feature **of utmost** importance in Genetic Programming.

This paper is organised as follows. Section 2 describes the GRN model **used,**
along with an analysis of its behaviour and modifications done in order to adapt it to the evolution of solutions for typical GP problems. Section 3 then describes the problem and the evolutionary algorithm we shall use to solve it. Section 4 describes some of the experiments conducted, and finally Section **5 draws** conclusions and discusses future work directions.

## 2 Artificial Gene Regulatory Model 2.1 Representation And Dynamics

The model used in this work [6] is composed of a genome, represented as a binary string, and mobile proteins, which interact with the genome through their binary signatures: they do so at regulatory sites**, located upstream from**
genes. The resulting interaction regulates the expression of the associated gene.

Genes are identified within the genome by Promoter sites**. These consist of**
an arbitrarily selected 32 bit bit pattern: the sequence XYZ01010101 **identifies a** gene, with X, Y and Z **representing each an arbitrary sequence of 8 bits.**
If a promoter site is found, the 160 bits (5×**32) following it represent the gene**
sequence, which encodes a protein. This protein (like all others in the model) is a 32 bit sequence, resulting from a many-to-one mapping of the gene sequence: each bit results from a majority rule for each of the five sets of 32 bits.

Upstream from the promoter site exist two additional 32 bit segments, representing the enhancer and inhibitor **sites: these regulate the protein production**
of the associated gene. The attachment of proteins to these regulatory sites is what regulates this production. Fig. 1 illustrates the encoding of a gene.

The binding of proteins to the regulatory sites is calculated through **the use**
of the XOR **operation, which returns the degree of match as the number of bits set**
to one (that is, the number of complementary bits between both binary strings).

The enhancing and inhibiting signals regulating the production of protein pi are calculated by the following equation:

$$e_{i},h_{i}={\frac{1}{N}}\sum_{j=1}^{N}c_{j}\exp(\beta(u_{j}-u_{m a x}))$$
$$(1)$$
cj exp(β(uj − umax)) (1)