Model Input **In order to introduce the notation of an input signal, the current**
model was extended through the insertion of extra proteins**: regulatory proteins**
not produced by genes, which are inserted into the model at a given **time.**
Like the proteins which are produced by the genes in the model, these are also 32-bit binary strings, and like the other regulatory proteins, they cooperate in the regulation of the expression of all genes, through the application of Eq. 1. However, since they are not produced by specific genes, their concentration is always the same across time (unless intentionally modified, see below).

As these are regulatory proteins, their concentration is considered to take up part of the regulatory process. This means that the differential equation used (Eq. 2) to calculate the expression level of TR-genes is changed as **follows:**

$$\frac{dc_{i}}{dt}=\delta(e_{i}-h_{i})c_{i}-\Phi(1.0-\sum_{j=N+1}^{N_{ep}}c_{j})\tag{3}$$
$\frac{1}{2}$ 2. 
where N + 1, . . . , Nep **are the indices of the extra proteins in the model, and**
Φ(1.0 −PNep j=N+1 cj **) is a term that proportionally scales protein concentrations,**
such that the sum of all protein concentrations (gene expression **and extra proteins) adds up to 1**.0.

These extra proteins can be associated with problem inputs in two ways:
- **The binary signatures of the proteins represent the input values;** - **The concentrations of the proteins represent the input values.**
Each has its advantages and disadvantages. Setting binary signatures allows evolution to exploit binary mutation to find useful matches between **binary signatures, but has a low resolution for continuous domains. Setting quantities is**
more adequate to represent continuous domains, but can be hard **to tune - a low** extra protein concentration will hardly influence the regulatory process, whereas a high concentration might crush the role of TF-genes.

Model Output **As mentioned before, each gene in the model encodes a transcription factor, which is used in the regulatory process. In nature, however, these**
are only a subset of the proteins expressed by genes. One could have proteins with different roles in the model, and use some as outputs of the model.

Keeping this idea in mind, the model has been adapted, so that different kinds of promoters can be detected, to identify different types of **gene. This**
allows one to give specific roles to the proteins produced by each type of gene.

In this work, two types of genes were identified in the model: genes encoding transcription factors (TF-genes) and genes encoding a product protein (**P-genes**).

The first ones act just like in the original model [6]: their proteins regulate the production of all genes, regardless of their type. The second **ones are only** regulated: their actual output signal is left for interpretation to **the objective** function. In order to identify different types of genes, the genome is scanned for different promoter sites. Dropping the ambiguous sequence used in **the original**
model (see Section 2.1), the following binary sequences were used: XYZ00000000