where g = 9.8 m/s2is the gravity, l = 0.5 m the half-pole length, F(t) = ±10 N
is the bang-bang command allowed, m = 0.1 kg and mc = 1.**0 kg are the masses**
of the pole and the cart respectively.

A time step of 0.02s **is used throughout the simulations. A failure signal is**
associated when either the cart reaches the track boundaries (x = ±2.4m**), or**
the pole falls (i.e., |θ| > 12◦).

The resulting controller accepts the four inputs, and outputs one **of two**
answers: push the cart left or right (with constant force F(t) = ±10N).

## 3.1 Encoding The Problem

The four inputs were encoded using extra proteins, as explained in Section 2.3. These had the following signatures:
x: 00000000000000000000000000000000 θ: 00000000000000001111111111111111 x˙: 11111111111111110000000000000000 ˙θ: 11111111111111111111111111111111 They were chosen such that their signatures are as different as possible. Their concentration dictates their value: each of them had the corresponding value of the input variable, scaled to the range [0.0, 0.**1]. This means that the cumulated** regulatory influence of these extra proteins ranged from 0% up to **40%.**
The GRN was allowed to stabilize first, and then tested against a random cart state, as seen in the literature. This is thus a very noisy fitness function, as several combinations of the four input variables result in unsolvable states (i.e. the pole cannot be balanced). Success is dictated by a successful series of 120000 time steps without the cart exiting the ±2.4m **track, or the pole falling**
beyond the ±12◦**range. The (minimising) fitness is thus:**

## F(X) = **120000** Sucessful Time Steps

The output action extracted from the genome is the concentration of a single P-protein: a concentration above 0.**5 pushes the cart right, and vice-versa. In** the current work, all P-genes that are present in the genome are **tested, and the** most successful one is used.

As relevant concentration must be close to 0.**5, small genomes were used (the**
higher the number of P-genes, the lower the probability of having a 0.**5 P-protein** concentration). The genomes were hence initialised with only 7 DM events, with 2% mutation rate, generally leading to very small genomes.

As an alternative to this approach, another technique was used, which consists in extracting the derivative of the chosen P-gene expression: if the derivative is positive between measuring times (i.e. if the concentration of the P-protein increased), then the cart is pushed right; otherwise, it is pushed left. If there was no change in its concentration, then the previous action is repeated.

Another choice lies with the synchronisation between the cart model and the regulatory model, that is, when to extract the current concentration of the