
## 4.1 Generalisation Performance

Whitley et al. [11] proposed a generalisation test to assert whether **the discovered**
solution is robust. Once a controller is evolved that can balance the pole for 120000 time steps with a random setup, the evolution cycle is stopped, and this controller is applied to a series of generalisation tests. These consist of combinations of the four input variables, with their normalised values **set to the**
following: 0.05, 0.275, 0.50, 0.725, and 0.95. This results in 54 **= 625 initial cases.**
The generalisation score of the best individual found is thus the number of test cases out of these 625, for which the controller manages to balance the pole for 1000 time steps.

All 50 runs found solutions for this problem, using either P-protein concentrations or P-protein tendencies (for both random and DM-genomes). At the end of each run, the generalisation test was applied to the best individual in the population; Table 1 shows the results obtained.

Table 1. **Generalisation results. Number of successful attempts to balance the pole for**
1000 time steps, out of 625 test cases

| Approach   | Best Worst Median Mean Std. Dev.   |     |     |        |        |        |
|------------|------------------------------------|-----|-----|--------|--------|--------|
| Product    | random genomes 422                 | 3   | 194 | 202.18 | 110.01 |        |
| Percentage | DM-genomes                         | 416 | 23  | 237    | 235.68 | 107.85 |
| Product    | random genomes 359                 | 0   | 63  | 85.82  | 66.99  |        |
| Tendency   | DM-genomes                         | 187 | 7   | 77     | 81.40  | 48.33  |

The results obtained show little difference between random and DM-genomes.

However, there is a big difference between using P-proteins concentrations or tendencies, with the former achieving much better results. When using product tendency, the concentration of P-proteins can easily become 0%: **the previous**
move is then repeated, and keeps moving the cart leftwards. This creates a disassociation between the product expression and the cart behaviour, which becomes a handicap when applying the model to some of the harder generalisation tests.

Note that many of the generalisation tests are unsolvable. After an exhaustive search of all possible bang-bang solutions up to 60 steps of simulation, 168 tests were found unsolvable (execution time constrains prevented a deeper search). This means that an ideal controller can only solve 457 (or less) cases. It also shows that the best result found (422 tests solved), although not as high as one of the best in the literature (446 solved cases [11]), is still quite close **to the** optimum.

Fig. 3 shows a plot of all the generalisation tests that are not solvable at depth 60, and those that are additionally not solved by the best random and DMgenome. It shows that cases where θ and ˙θ **both take large or small values (i.e. a**
large angle in absolute value, together with a large angular velocity increasing this angle) are unsolvable, and that both genomes additionally fail on cases