# A Soft Computing Model For Physicians' Decision Process

Siddhartha Sankar Biswas Abstract— In this paper the author presents a kind of Soft Computing Technique, mainly an application of fuzzy set theory of Prof. Zadeh [16], on a problem of Medical Experts Systems. The choosen problem is on design of a physician's decision model which can take crisp as well as fuzzy data as input, unlike the traditional models. The author presents a mathematical model based on fuzzy set theory for physician aided evaluation of a complete representation of information emanating from the initial interview including patient past history, present symptoms, and signs observed upon physical examination and results of clinical and diagnostic tests. 

Index Terms— Fuzzy set, hard computing, soft computing, history, symptom

## 1 **Introduction**

Most of the existing mathematical models of physician decision process offered to date, especially those relative to diagnosis and patient treatment 
[1-3,5,9-11,13,14] suffer from the inability to incorporative all useful real data on the patient. 

Pertinent information so neglected or poorly modeled relate to variables that are intrinsically fuzzy but which describe that patient's health status. Considering the real situation of illiterate farmers, villages of remote rural areas on health care and medical systems, it is felt that a softcomputing based solution would be an improved solution. 

## 1.1 What Is Soft Computing?

Soft computing differs from conventional (hard) 
computing in that, (unlike hard computing), it computes exploiting the tolerance of imprecision, uncertainty, partial truth, and approximation. In effect, the role model for soft computing is the human mind. The guiding principle of soft computing is: Exploit the tolerance for imprecision, uncertainty, partial truth, and approximation to achieve tractability, robustness and low solution cost. 

The principal constituents of Soft Computing (SC) are [4,6-8,12,15-17]:- 
Fuzzy Logic (FL), Rough Logic, Soft Set Logic, Neural Computing (NC), Genetic Computing, Evolutionary Computation (EC) Machine Learning (ML) and Probabilistic Reasoning (PR), with the latter subsuming belief networks, Fractal Theory, Chaos Theory, Probability Theory, Possibility Theory, and Learning Theory. 

## 1.2 **Justification Of The Need Of** Soft Computing Techniques

In this paper I present a model which is based on real life input data like patient past history, present symptoms, and signs observed upon physical examination and results of clinical and diagnostic tests. This real input data are not all crisp in nature, rather fuzzy. Most of the data are nonnumeric, viz. "good", "very good", "low pH", 
"high turbidity", "less alkalinity", "high BOD", 
"poor sanitation", etc. to list a few only out of infinity. Such type of data are fuzzy in nature. 

Evaluation of many objects is not possible by hard computing but by the application of powerful softcomputing techniques. 

## 2 The General Diagnostic Process: A Systems Description

The diagnostic decision process is a sequence of decisions made by a physician in an attempt to identify and explain the ailments, disorders and diseases present in a particular sick patient. This process involves the acceptance of the patient into the physician's care, and the collection and evaluation of pertinent information at various intermittent stages. Such information, obtained through discussion, observation, and tests, is significant to the convergence upon effective preliminary and final diagnosis. Fig I illustrates this process as well as the general treatment decision process. 