Other variations of restricted set cover type problems also exist, **such as Exact** 34
-Set Cover [19], which was used to show the NP-completeness of bribery in the Borda count election [10].

An important problem used in showing complexities of problems involving **control by adding or deleting**
candidates is Hitting Set. Name: Hitting Set **[20] (See also [17, problem SP8])**
Instance: A set S = {s1, . . . , sm}, n subsets of S, T1, . . . , Tn**, and positive integer 1** ≤ q ≤ m.

Question: Does there exist a subset of q **elements of** S, S
′ = {si1
, . . . , siq }**, such that** S
′ ∩ Ti 6= ∅ **for each**
1 ≤ i ≤ n? Thus, each subset Ti **contains at least one element of** S
′.

Hitting Set can also be viewed as a generalization of Vertex Cover to hypergraphs, where edges connect an arbitrary number of vertices. This problem was used to prove that unweighted plurality elections are computationally resistant to control by adding and deleting candidates in [16]. We will generalize this result.

## 6 Edge Covering And Edge Matching Problems

We will show in this paper that some problems in some election systems are closely related to problems involving edge coverings. This is especially true for elections that distinguish two candidates from the remaining candidates. Due to this connection, these problems generally have similar complexities to that of some forms of edge covering problems. An edge cover, as well as the well-known decision problem of Edge Cover, is defined as follows. Definition 1 An edge cover **of a graph is a set of edges such that every vertex of the graph is incident to**
at least one edge of the set. Name: Edge Cover **[20] (See also [17, pages 79, 190])**
Instance: An undirected graph G = (V, E**) and positive integer** q. Question: Does there exist an edge cover C ⊆ E for G **of size at most** q?

It is possible to find a smallest edge cover in polynomial time, by finding a **maximum matching and**
extending it greedily so that all vertices are covered. We will use several interesting variations of Edge Cover in this paper, which are defined as follows.

In the variation b-Edge Cover, each vertex v is to be covered by a minimum of some number, b(v**), of edges.**
There are several interesting variations of this problem: Each edge can be chosen only once (Simple b**-Edge** Cover), an arbitrary number of times (b**-Edge Cover), or have a capacity and be chosen up to that many** times (Capacitated b**-Edge Cover) (see [18] sections 34.1, 34.7, and 34.8), all of which are polynomial-time**
computable [29, 30, 31, 32]. In each case, polynomial-time computability is due to the relationship between edge coverings and edge matchings. More specifically, the size of the minimum edge covering and the size of the maximum edge matching always sum to the total of the b**-values. The maximum edge matching can**
then be computed using linear programming.