Instance: An undirected multigraph G = (V, E**), a function** b : V → Z
+**, weight function** w : E → Z
+ and positive integer q.

Question: Does there exist a subset of at most q edges C ⊆ E such that each vertex v ∈ V **is incident to**
edges in C **of at least total weight** b(v)?

In these two versions, as we will see later, the weighted edges correspond to cases of bribery in which each voter has an associated price. The weighted coverings correspond to manipulations involving weighted voters.

It is currently unknown whether either of these variations are polynomial-time computable, NP-intermediate, or NP-complete. We will show in this paper that some problems of interest are polynomial-time equivalent to one of these problems.

A related problem involves edge matchings. See [18] for the connection between matchings and coverings, and the extension of Edge Matching to b**-Edge Matching, and the polynomial-time computability result. We**
will define an analogous problem for multigraphs as follows.

Name: Simple b**-Edge Matching of Multigraphs**
Instance: An undirected multigraph G = (V, E**), a function** b : V → Z
+ **and positive integer** q.

Question: Does there exist a subset of at least q edges C ⊆ E such that each vertex v ∈ V **is incident to**
at most b(v**) edges in** C?

This is an extension of Edge Matching. In a traditional Edge Matching problem, each vertex has a b**-value**
of b(v**) = 1, as a matching cannot cover a vertex more than once.**

## 7 Misuses In Elections With A Fixed Number Of Candidates

In [21], it is shown that bribery of unweighted scoring protocol elections can be solved in polynomial time with brute force when the number of candidates is fixed, since the number of possible preference orderings is also fixed, and that voters with equal preferences are not distinguishable (see the definition of succinct preference representation in Section ??**). The same principle also applies to control by adding or deleting** voters, as well as manipulation. Bribery of fixed scoring protocols is **also polynomial-time computable even** when voters have prices, since it suffices to bribe only the cheapest **voters among those with equal preferences.**
We review the result for $bribery from [21] below.

Theorem 2 [21] α-$bribery is polynomial-time computable for all scoring protocols α = (α1, . . . , αm) **with**
a fixed number of candidates m. Proof: Because m is a constant, there are only a constant, m**!, number of distinct preference profiles. The**
algorithm given in [21] partitions the set of voters into m! subsets, V = V1 ∪ · · · ∪ Vm!**, with voters in each**
subset having equal preferences. A bribery can then be described by two sequences of integers, b1**, . . . , b**m!, and d1, . . . , dm!, where each biindicates how many voters from Vi we are bribing and di**indicates how many**
voters will be given the preferences of Vi**. Without loss of generality, we can assume we are bribing the**
cheapest bi **voters of the set** Vi.