This reduction can also be extended to k-veto elections for all k > 4, by adding k **buffer candidates in**
total.

In the next result, we see how a slightly modified form of the greedy algorithm introduced in [21] can be used to bribe 2-veto elections. Theorem 10 Unweighted 2-veto elections are computationally vulnerable to bribery **by unpriced voters.**

## Proof: Consider An Election E = (C, V ) And Quota Q > 0.

Without loss of generality, we will only bribe voters that veto p. If no voters veto p, then p **is a winner**
and we can accept. Similarly, if p has at most q vetoes, then we can bribe these voters and make p **a winner.** Thus, we will assume that p has more than q **vetoes. Also without loss of generality, we will not bribe any** voters to veto p.

For each candidate c ∈ C, let Vetoes(c) be the number of vetos currently received by candidate c**, and**
for c1 6= c2, Vetoes(c1, c2) be the number of voters who veto both c1 and c2**. Then, following our bribery**
of q voters, p will receive exactly Vetoes(p) − q **vetoes. Since we don't want any candidate to have fewer**
than this many vetoes, for each c 6= p, we can bribe up to max(Vetoes(p, c), Vetoes(p)−Vetoes(c)−q**) voters** whom veto both p and c and ensure that c **will not beat** p.

We will thus bribe a total of

$$\operatorname*{max}(\sum_{c\neq p}\operatorname*{max}(\operatorname{Vetoes}(p,c),\operatorname{Vetoes}(p)-\operatorname{Vetoes}(c)-q),q)$$

voters. The votes chosen does not matter, since we are removing **vetoes from candidates who will not beat** p, and we are bribing the maximum number of votes feasible. We must then assign these votes such that each candidate currently beating p receives enough vetoes to lose to p**. This is similar to the polynomial-time**
computable problem of 2-veto manipulation.

The next two results, of bribery of 2-approval and 3-veto elections, demonstrate the connection between the seemingly unrelated problem of Simple b**-Edge Cover and manipulating election systems. We will see**
in this and other results that this connection occurs most often when the election system distinguished two candidates from the remaining candidates. This is because the connection equates candidates to vertices of graphs and voters to edges, with the two candidates being distinguished by each voter equated with the two vertices connected by the corresponding edge. Theorem 11 Unweighted 2**-approval elections are computationally vulnerable to bribery by unpriced voters.**
Proof: We solve 2-approval bribery using Simple b**-Edge Cover.**
Consider an election E = (C, V ). We wish to ensure the victory of p by bribing at most q **voters.** We first observe that, without loss of generality, we will only bribe voters that do not approve of p**. If**
there are no more than q such voters, then all voters will approve of p and p **will win. Thus, without loss** of generality, we assume that more than q voters do not approve of p**. Also without loss of generality, we**