
## 12 Controlling An Election Via Candidates

The chair of an election can also attempt to influence the outcome by **affecting the voter set, dictating rules**
for candidates that may or may not participate in the election. A common example is that of cloning, in which a winning candidate is made worse off by the addition of a similar candidate, causing the votes to be split among them, and possibly allowing a third independent candidate to win.

We briefly review the known complexities of this problem given in [16] and [14] and demonstrate how to generalize it to other cases of approval elections. Control by adding and deleting candidates is hard in both the constructive and destructive case in two of the simplest families **of scoring protocols: plurality and veto.**
The reductions given in [16, 14] are from Hitting Set.

## 12.1 Destructive Control

In [14], a construction was given demonstrating that destructive control via either adding or deleting candidates in a plurality election is NP-hard, via a reduction from Hitting Set. We demonstrate how to generalize this reduction to the cases of k-approval by adding buffer candidates, and then to k**-veto by making some**
modifications. This hardness result for adding candidates is also shown independently in [105].

Theorem 20 k**-approval elections are computationally resistant to destructive control by either adding or**
deleting candidates.

Proof: **Consider an instance of Hitting Set, where we are given a set**
S = {s1**, . . . , s**m},
n subsets of S, T1, . . . , Tn**, and positive integer 1** ≤ q ≤ m.

In our election, the candidate set will consists of

$$C=\{c,c^{\prime}\}$$
 $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup$$ $$\cup $$\cup$$ $$\cup $$\cup $$\
C = {c, c′} ∪ S
∪ {x
$\{x_{i,j}^{1}\ |\ 1\leq i\leq2(m-q)+2n(q+1)+4,1\leq j\leq k\}$  $\{x_{i,j}^{2}\ |\ 1\leq i\leq2n(q+1)+5,1\leq j\leq k\}$  $\{x_{i,j,\ell}^{3}\ |\ 1\leq i\leq n,1\leq j\leq2(q+1),1\leq\ell\leq k\}$  $\{x_{i,j,\ell}^{4}\ |\ 1\leq i\leq m,1\leq j\leq2,1\leq\ell\leq k\}$.  
∪ {x
∪ {x
∪ {x
For each 1 ≤ i ≤ 2(m − q) + 2n(q **+ 1) + 4 we add a voter with preferences**
c ≻ x 1 i,1 **≻ · · · ≻** x 1 i,k−1 ≻ c
′ **≻ · · ·** ,

  ## 1 Introduction  The _classical_ quantum mechanics of a quantum system is a classical theory of quantum mechanics. It is a classical theory of quantum mechanics, which is a classical theory of quantum mechanics.  
$-\frac{1}{2}$  . 
and for each 1 ≤ i ≤ 2n(q **+ 1) + 5 we add a voter with preferences**

$$c^{\prime}\succ x_{i,1}^{2}\succ\cdots\succ x_{i,k-1}^{2}\succ c\succ\cdots.$$
$\frac{1}{2}-\frac{1}{3}=\frac{1}{2}$ 2. 
$22\frac{1}{2}$. 