
## 4 Definition Of Elections

An election E = (C, V ) is defined as a pair of a set of voters V = {v1, . . . , vn} **and a set of candidates**
C = {c1, . . . , cm}. Each voter vi **has a preference over the candidates. A common model for understanding**
voter preferences is that of the transitive voter model. In the transitive voter model, which we will use exclusively in this chapter, each preference is a strict linear ordering over the candidates ci1 **≻ · · · ≻** cim .

But voter preferences need not be transitive (see, e.g., [84], in which the voter submits a reflexive and antisymmetric binary ordering over the candidates C**). Furthermore, voters in some election systems cannot**
submit their vote simply as a preference ordering. A prominent example is approval, which we will define below.

Elections may be weighted or unweighted. In a weighted election, each voter vi has a weight, w(vi**), and**
their vote is counted as w(vi) individual votes in an unweighted election with the same preference **ordering.**

## 4.1 Election Systems Of Interest

An election system E **specifies how one arrives at the outcome given the collection of voter preferences.**
Depending on the context, the outcome we may be interested in may **be a winner, a nonempty subset of** winners, or an aggregate preference ordering. Most typically, an **election for us will be what in the literature** is called a social choice correspondence, namely, a mapping from the **candidates and the voter preferences** to a subset (known as the winner set) of the set of candidates. There are many systems of interest, some of which involve multiple rounds. Perhaps the most common election system in everyday use is that of plurality, in which the candidate(s) most frequently ranked first among the voters is elected. Plurality is an election system in a more general family of election systems called scoring protocols.

A scoring protocol (see the handbook article [92]) is defined over a vector (α1**, . . . , α**m) ∈ Z
m**. Each**
candidate c is given αi points for each voter that ranks c **in the** i th **position of his or her ranking. The**
candidate(s) with the highest score wins. In addition to plurality, common scoring protocols include veto, Borda count, and approval-based systems with a fixed number of candidates.

A family of scoring protocols **is an infinite series of scoring protocols (**α 1, . . . , αm, . . .**), where** α m =
(α m 1
, . . . , αmm) is a scoring protocol of m **candidates.**
In plurality, a common form of elections in political science, each voter gives one **point to his or her favorite**
candidate, whereas in veto**, each voter approves, or gives one point, to all but one candidate: This has the** effect of vetoing one candidate. Plurality and veto can thus be considered a family of scoring protocols of the form α m = (1, 0, . . . , **0) and** α m = (1, . . . , 1, **0) respectively.**
In k-approval, each voter gives his or her k favorite candidates 1 point. Similarly, in k-veto**, each voter**
vetoes his or her least k **favorite candidates.**
Although not a scoring protocol, another common election system is approval **[91]. In approval voting,**
each voter can approve as many or as few candidates as he/she chooses. In some models, voters may still have a preference order, along with the number of candidates **approved. The winner(s) is thus the** candidate(s) with the most number of approvals (or weights thereof). In [21, 14], it is shown that approval is computationally resistant to many forms of misuse involving the voter set, even with unweighted voters, for constructive and destructive cases. We will in fact examine the **properties of this election system that**