Instance: A set C of candidates, a set V of voters, distinguished candidate p**, and nonnegative integer quota**
q.

Question (constructive bribery): Is it possible to make p a winner of the E **election by changing the**
preference profiles of at most q **voters in** V .

Question (destructive bribery): Is it possible to make p not a winner of the E **election by changing the**
preference profiles of at most q **voters in** V .

As in the cases of manipulation, bribery is also defined for cases of weighted voters. As above, we denote this problem E-weighted-bribery. In addition, each voter v can be assigned a price tag π(v**) of a nonnegative** integer. In this case, q **is our budget, and we want to achieve our goal (constructive or destructive bribery)** by spending at most q in our bribery. We denote this problem by E-$bribery and E**-weighted-$bribery if**
voters have both weights and prices. There are six problems of interest in the case of control, as we may add, delete, or partition, either voters or candidates. Also in all of **these cases, voters may be weighted.**
The cases of constructive control, except the versions used here of adding candidates, are from [16], while those of destructive control, as well as the versions of constructive control by adding candidates used here, are from [14]. Name: E**-Control by Adding Voters**
Instance: A set C of candidates, a set V **of established voters, and** V
′ **of unestablished voters such that**
V ∩ V
′ = ∅, distinguished candidate p**, and nonnegative integer quota** q.

Question (constructive control): **Does there exist a subset** V
′′ ⊆ V
′ **with** ||V
′′|| ≤ q such that p **is a**
winner of the E election with candidate set C **and voter set** V ∪ V
′′?

Question (destructive control): **Does there exist a subset** V
′′ ⊆ V
′ **with** ||V
′′|| ≤ q such that p **is not a**
winner of the E election with candidate set C **and voter set** V ∪ V
′′?

Name: E**-Control by Deleting Voters**
Instance: A set C of candidates, a set V of established voters, distinguished candidate p**, and nonnegative**
integer quota q.

Question (constructive control): **Does there exist a subset** V
′ ⊆ V **with** ||V
′|| ≤ q such that p **is a**
winner of the E election with candidate set C **and voter set** V − V
′?

Question (destructive control): **Does there exist a subset** V
′ ⊆ V **with** ||V
′|| ≤ q such that p **is not a**
winner of the E election with candidate set C **and voter set** V − V
′?

Name: E**-Control by Partitioning Voters**
Instance: A set C of candidates, a set V **of established voters, and distinguished candidate** p.

Question (constructive control): Does there exist a partition of candidates V = V1 ∪ V2 **such that** p is a winner of the election with the candidates given by the union of the winners of E1 = (C, V1**) and** E2 = (**C, V**2)?

Question (destructive control): Does there exist a partition of candidates V = V1 ∪ V2 **such that** p is not a winner of the election with the candidates given by the union of the winners of E1 = (C, V1**) and** E2 = (**C, V**2)?