Name: E**-Control by Adding Candidates**
Instance: A set C of candidates, a set V **of established voters, and** C
′ **of unestablished voters such that**
C ∩ C
′ = ∅, distinguished candidate p**, and nonnegative integer quota** q.

Question (constructive control): **Does there exist a subset** C
′′ ⊆ C
′ **with** ||C
′′|| ≤ q such that p **is a**
winner of the E **election with candidate set** C ∪ C
′′ **and voter set** V ?

Question (destructive control): **Does there exist a subset** C
′′ ⊆ C
′ **with** ||C
′′|| ≤ q such that p **is not a**
winner of the E **election with candidate set** C ∪ C
′′ **and voter set** V ?

Name: E**-Control by Deleting Candidates**
Instance: A set C of candidates, a set V of established voters, distinguished candidate p**, and nonnegative**
integer quota q.

Question (constructive control): **Does there exist a subset** C
′ ⊆ C **with** ||C
′|| ≤ q such that p **is a**
winner of the E **election with candidate set** C − C
′ **and voter set** V ?

Question (destructive control): **Does there exist a subset** C
′ ⊆ C\{p} **with** ||C
′|| ≤ q such that p **is not**
a winner of the E **election with candidate set** C − C
′ and voter set V **? In this case, note that we may**
not deleted the candidate p **in which we are manipulating against.**
Name: E**-Control by Partitioning Candidates**
Instance: A set C of candidates, a set V **of established voters, and distinguished candidate** p.

Question (constructive control): Does there exist a partition of candidates C = C1 ∪ C2 **such that** p is a winner of the election with the candidates given by the union of the winners of E1 = (C1, V **) and** E2 = (C2, V )?

Question (destructive control): Does there exist a partition of candidates C = C1 ∪ C2 **such that** p is not a winner of the election with the candidates given by the union of the winners of E1 = (C1, V **) and**
E2 = (C2, V )?
In all of these cases, we say that an election is computationally vulnerable **to a particular form of misuse,**
such as manipulation, bribery, or control if the corresponding problem is polynomial-time computable. The election is computationally resistant **to the misuse if the corresponding problem is NP-hard.**

## 5.1 Some Important Np-Complete Problems

Common NP-complete problems of choice for showing NP-hardness of election systems include versions of Set Cover, Knapsack, and Hitting Set.

Exact 3-Set Cover (X3C) is a common restricted version of Set Cover.

Name: Exact Cover by 3-Sets (X3C) **[20] (See also [17, problem SP2])**
Instance: A set S = {s1, . . . , s3m} and subsets T1, . . . , Tn ⊆ S such that ||Ti|| **= 3.**
Question: Does there exist a set A ⊆ {1, . . . , n} such that ||A|| = m and Si∈A
Ti = S?