
## 2.2. Intrusion Detection Overview

Intrusion detection is the process of monitoring and analyzing the events in computer systems or 

![0_image_0.png](0_image_0.png)

networks to discover the signals of possible incidents, which attempt to compromise the confidentiality, integrity, and availability of computer resources. In general, IDS use misusebased and anomaly-based detection model for detecting intrusions. Misuse-based IDS are very effective for detecting known attacks but largely ineffective for detecting new attacks whose pattern has not stored in the database yet. It performs pattern matching to match an attack pattern corresponding to known attack patterns in the database. Anomaly-based IDS identify new attacks by analyzing anomalous behavior from normal behaviors. It has a relatively high detection rate for new attack, but produces many false positives. It uses profiles that are developed by monitoring the characteristics of typical activities over a period of time and then compares the characteristics of current activity to thresholds related to the profile. A networkbased IDS (NIDS) monitor and analyze network traffics, and use multiple sensors for detecting intrusions from internal and external networks [20]-[22]. IDS analyze the information gathered by the sensors, and return a synthesis of the input of the sensors to system administrator or intrusion prevention system. System administrator carries out the prescriptions controlled by the IDS. Today, data mining has become an indispensable tool for analyzing the input of the sensors in IDS. Fig. 1 shows a scenario of IDS to protect server machine from internal and external network. 

Ideally, IDS should have an attack detection rate (DR) of 100% along with false positive (FP) of 0%. Nevertheless, in practice this is really hard to achieve. The most important parameters involved in the performance estimation of IDS are shown in Table 1. 

| Parameters                                | Definition                    |
|-------------------------------------------|-------------------------------|
| True Positive (TP) or Detection Rate (DR) | Attack occur and alarm raised |
| False Positive (FP)                       | No attack but alarm raised    |
| True Negative (TN)                        | No attack and no alarm        |
| False Negative (FN)                       | Attack occur but no alarm     |

Table 1. Parameters for performance estimation of IDS. 