
## 3. Basic Problems Of L**Earning** 3.1. Handling Noise In Dataset

Noise in the dataset is considered to be one of the most challenging issues in data mining. This is because the performance of the learning algorithms depends on the quality of dataset. The main idea of dealing with noisy data at the learning time is to avoid over-fitting the dataset. 

Noise handling can be carried out at different stages of rule induction and interpretation. The followings exhibit some typical noises being existed in the dataset. 

1) **Missing attribute values: The simplest way for handling missing or unknown attribute** 
value is to replace the missing attribute value with the most frequent attribute value in the dataset. Whereas, the most sophisticated way is to calculate the probability for attribute values and assign the probability value rather than the guessed value to each missing attribute value. 

2) **Contradictory examples: The same examples appear more than once in the dataset with** 
different class labels. Contradictory examples confuse the learning algorithms, so these examples should be avoided or labeled correctly before learning. 

3) **Redundant examples: There often exist multiple copies of the same example in the** 
dataset. Redundant examples are not a problem if they do not form contradictions, but this redundancy can change the decision trees produced by ID3 algorithm. For data mining, it's better to remove redundancy by keeping only a unique example in the dataset. By doing so, it not only saves the space of storage in dataset but also speeds significantly up the learning process. 

4) **Incomplete attribute problem: When the essential attributes of a problem are not used to** 
describe in the dataset. Suppose to distinguish men from women based on the descriptions of a large group of people in terms of gender, height, weight, qualifications, and so on. The right attribute for men is "gender = male" and women is "gender = 
female". If we cannot catch the right attribute, then the classification model will be more complex and less accurate. 

5) **Misclassified examples: The examples in the dataset ware labeled with a wrong** 
classification. 

## 3.2. Dealing With Continuous Attribute

The goal of dealing with continuous attributes is to discretized the continuous attribute containing continuous values (i.e., real numbers or integers) into a number of intervals. The discretized intervals can be treated in a similar way to nominal values during learning and classification. It is very important for discretization of continuous attribute to find the right places to set up interval borders. The simplest technique is to place the interval borders of continuous attribute values between each adjacent pair of attribute values that are not classified into the same class. Suppose the pair of adjacent values on attribute Ai are Ai1 and Ai2, "A = (Ai1+Ai2**)/2" can be taken as an interval border. The information gain technique adopted in ID3** 
algorithm is another very efficient technique to find the most informative border to split the values of the continuous attribute. The maximum information gain is always considered for a cut point (the midpoint) between the values taken by two attribute values of different classes. 

Each value of the formula "A = (Ai +Ai+1)/2" where *i = 1,…,n-1* is a possible cut point, if Ai **and** 
Ai+1 **have been taken by different class values in the dataset. The purpose of employing** 
information gain is to check each of the possible cut points and find the best split point. In C4.5 algorithm, each of the possible cut points is not the midpoint between the two nearest values, 