

![0_image_0.png](0_image_0.png) 
Figure 1: Illustrative examples on (a) a commonly shared conceptual categorization (hierarchy) by various users; (b)
personal hierarchies expressed by the users based on the conceptual categorization as in (a). Nodes with similar name have similar color just for an illustrative purpose.

describe how saplings are represented through social annotation on Flickr. We subsequently review the standard affinity propagation algorithm and describe our relational extension to it. Finally, we apply the method to real data sets and show that the proposed approach is able to learn better, and more complete trees.

## Motivating Example

We take as our motivating example user-generated annotations on the Social Web. We assume that groups of users share common conceptualizations of the world, which can be represented as a taxonomy or hierarchy of concepts. Figure 1(a) depicts one such common conceptualization about
'animal' and its 'bird' subconcepts shared by a group of users. When users organize the content they create, e.g.,
photographs on Flickr, they select some portions of the common taxonomy for categorization. We observe these categories through the shallow personal hierarchies Flickr users create, which we refer to as *saplings*. Figure 1(b) depicts some of the saplings specified by different users to organize their 'animal' and 'bird' images. Our ultimate goal is to infer common conceptual hierarchies from the many individual saplings. One natural solution is to aggregate saplings shown in Figure 1(b) together into a deeper and bushier tree shown in Figure 1(a).

To aggregate saplings, we need a combining strategy that measures the degree to which two sapling nodes should or should not be merged. Suppose that we have a very simple combining strategy that says two nodes are similar if they have similar names as in the prior work (Plangprasopchok and Lerman 2009). From Figure 1(b), we will end up with a graph containing one loop and two paths from 'animal' to 'bird', rather than the tree shown in Figure 1(a). Suppose that we can also access tags with which users annotated photos within saplings, and that photos within "domestic bird" nodes have tags like "pet," and "farmed" in common, and photos belonging to "wild bird" nodes have tags like "wildlife" and "forest" in common. A cleverer similarity function that, in addition to node names, takes tag statistics within a node into consideration, should split 'bird' nodes into two different groups: 'domestic bird' and 'wild bird',
which are put under "pet" and "wildlife" nodes respectively.

The similarity function plays a crucial part in integrating saplings, and a sophisticated enough similarity function that can differentiate node senses in detail, may potentially correctly integrate the final tree. Nevertheless, finding and tuning such function is very difficult; moreover, the data is often inconsistent, noisy and incomplete, especially on the Social Web, where data is generated by many different users.

One possible way to tackle this challenge is to use a simple similarity function and incorporate constraints during the merging process. Intuitively, we would not consider merging the 'bird' node under 'pet' with the one under 'wildlife' because it will result in multiple paths from 'animal'. These structural constraints are used during sapling aggregation process to ensure that the learned structure is a tree. Specifically, the constraints prevent two nodes from being merged if (1) this will lead to links from different parent concepts or (2) this will lead to an incoming link to the root node of a tree. These constraints guarantee that there is, at most, a single path from one node to another.

## Structured Metadata In Flickr

Structured data in the form of shallow hiearchies is ubiquitous on the Social Web. On *Flickr*, users can *arbitrarily* group related photos into *sets* and then group related sets in collections. Some users create multi-level hierarchies containing collections of collections, etc., but the vast majority of users who use collections create shallow hierarchies, consisting of collections and their constituent sets. These personal hierarchies generally represent subclass and partof relationships. We formally define a *sapling* as a shallow tree representing a personal hierarchy which composed of a root node r i and its children, or leaf, nodeshl i1
, ..lij i. The root node corresponds to a user's collection, and inherits its name, while the leaf nodes correspond to the collection's constituent sets and inherit their names. We assume that hierarchical relations between a root and its children, r i → l i j
, specify broadernarrower relations.

On Flickr, users can attach tags only to photos. A
sapling's leaf node corresponds to a set of photos, and the tag statistics of the leaf are aggregated from that set's constituent photos. Tag statistics are then propagated from leaf nodes to the parent node. We define a tag statistic of node x as τx := {(t1, ft1
),(t2, ft2
), · · ·(tk, ftk
)}, where tk and ftk are tag and its frequency respectively. Hence, τr i is aggregated from all τl i j s. These tag statistics can also be used as a feature for determining if two nodes are similar (of the same concept).

## Affinity Propagation

A key component of folksonomy learning through sapling integration is the merging similar nodes in different saplings.

Merging similar root nodes expands the width of the learned tree, while merging the leaf of one sapling to the root of another extends the depth of the learned tree. We cast the merging process as clustering sapling nodes, and we use affinity propagation to perform the clustering. Below, we briefly review the original AP and then describe our extension, which incorporates structural constraints, and refer to the extended version as *Relational Affinity Propagation (RAP)*.