
## Affinity Propagation(Ap)

Affinity Propagation (Frey and Dueck 2007) is a clustering algorithm that identifies a set of exemplar points that are representative of all the points in the data set. The exemplars emerge as messages are passed between data points, with each point assigned to an exemplar. AP attempts to find the exemplar set which maximizes the net similarity, or the overall sum of similarities between all exemplars and their data points.

In this paper, we describe AP in terms of a factor graph (Kschischang, Frey, and Loeliger 2001) on binary variables, as recently introduced by Givoni and Frey (Givoni and Frey 2009). The model is comprised of a square matrix of binary variables, along with a set of factor nodes imposed on each row and column in the matrix. Following the notations defined in the original paper (Givoni and Frey 2009),
let cij be a binary variable. cij = 1 indicates that node i belongs to node j (or, j is an exemplar of i); otherwise, cij = 0. Let N be a number of data points; consequently, the size of the matrix is N × N.

There are two types of constraints that enforce cluster consistency. The first type, Ii, which is imposed on the row i, indicates that a data point can belong to only one exemplar
(Pj cij = 1). The second type, Ej , which is imposed on the column j, indicates that if a point other than j chooses j as its exemplar, then j must be its own exemplar (cjj = 1).

AP avoids forming exemplars and assigning cluster memberships which violate these constraints. Particularly, if the configuration at row i violates I constraint, Ii will become
−∞ (and similarly for Ej ).

In addition to the constraints, there is a similarity function S(.), which indicates how similar a certain node is, to its exemplar. If cij = 1, then S(cij ) is a similarity between nodes i and j; otherwise, S(cij **) = 0**. S(cjj ) evaluates
"self-similarity," also called "preference", which should be less than the maximum similarity value in order to avoid all singleton points becoming exemplars. This is because that configuration yields the highest net similarity. In general, the higher the value of the preference for a particular point, the more likely that point will become an exemplar. In addition, we can set the same self-similarity value to all data points, which indicates that all points are equally likely to be formed as exemplars.

A graphical model for affinity propagation is depicted in Figure 2, described in terms of a factor graph. In a log-form, the global objective function, which measures how good the present configuration (a set of exemplars and cluster assignments) is, can be written as a summation of all local factors as follows:

$$\begin{array}{r c l}{{{\bf S}(c_{11},\cdots,c_{N N})}}&{{=}}&{{\sum_{i,j}S_{i j}(c_{i j})+\sum_{i}I_{i}(c_{i1},\cdots,c_{i N})}}\\ {{}}&{{}}&{{}}\\ {{}}&{{}}&{{+}}&{{\sum_{j}E_{j}(c_{1j},\cdots,c_{1N}).}}\end{array}\qquad\qquad(1)$$

That is, optimizing this objective function finds the configuration that maximizes the net similarity S, while not violating I and E constraints.

![0_image_0.png](0_image_0.png) 
Figure 2: The original binary variable model for Affinity Propagation proposed by Givoni and Frey(Givoni and Frey 2009): (a) a matrix of binary hidden variables (circles) and their factors(boxes); (b)incoming and outgoing messages of a hidden variable node from/to its associated factor nodes.

The original work uses max-sum algorithm to optimize this global objective function, and it requires updating and passing five messages as shown in Figure 2(b). Since each hidden node cij is a binary variable (two possible values),
one can pass a scalar message - the difference between the messages when cij = 1 and cij = 0, instead of carrying two messages at a time. The equations to update these messages are described in greater detail in the Section 2 of the original work (Givoni and Frey 2009).

Once the inference process terminates, the MAP configuration (exemplars and their members) can be recovered as follows. First, identify an exemplar set by considering the sum of all incoming messages of each cjj (each node in the diagonal of the variable matrix). If the sum is greater than 0
(there is a higher probability that node j is an exemplar), j is an exemplar. Once a set of exemplars K is recovered, each non-exemplar point i is assigned to the exemplar k if the sum of all incoming messages of cik is the highest compared to the other exemplars.

## Relational Affinity Propagation(Rap)

We extend the above algorithm to add in structural constraints that will ensure that the learned folksonomy makes sense - no loops, and, to the extent possible, forms a taxonomy. In fact, here, we require it to be a tree. Since we want the learned folksonomy to be a tree, all nodes assigned to some exemplar must have their incoming links from nodes in the same cluster, i.e., assigned to the same exemplar. To achieve this, we must enforce the following two constraints: (1) merging should not create incoming links to a cluster, or concept, from more than one parent cluster (single parent constraint); (2) merging should not create an incoming link to the root of the induced tree (no root parent constraint).

For the second constraint, we can simply discard all sapling leaves that are named similar to the tree root. Hence, we only need to enforce the first constraint. The first constraint will be violated if leaf nodes of two saplings are merged, i.e., assigned to the same exemplar, while the root nodes of these saplings are assigned to different exemplars. Consequently, the leaf cluster will have multiple parents pointing to it, which leads to an undesirable configuration.