into multiple terms, which we expand into leaves. Suppose
a user created a collection animal **containing a set** cats and dogs. After tokenization we get the sapling **animal** →
{cats, dogs}**. However, if the root node is determined to**
have a composite name, we ignore the entire sapling because
we do not know which parent concepts correspond to which
child concepts.
4.2 Relational Clustering of Structured Metadata
In order to learn a folksonomy, we need to aggregate saplings
both **horizontally and vertically. By horizontal aggregation,**
we mean merging saplings with similar roots, which expands the breadth of the learned tree by adding leaves to the root. By vertical aggregation, we mean merging one sapling's leaf to the root of another, extending the depth of the learned
tree. The approach we use exploits contextual information
from neighbors in addition to local features to determine
which saplings to merge. The approach is similar to relational clustering[1] and its basic element is the similarity
measure between a pair of nodes.
We define a similarity measure which combines heterogeneous evidence available in the structured social metadata, and is a combination of local similarity and structural similarity. The local similarity between nodes a and
b, localSim(a, b), is based on the intrinsic features of a and b**, such as their names and tag distributions. The structural**
similarity, structSim(a, b) is based on features of neighboring nodes. If a **is a root of a sapling, its neighboring nodes**
are all of its children. If a **is a leaf node, the neighboring**
nodes are its parent and siblings. The similarity between
nodes a and b is:
$$\begin{array}{r c l}{{n o d e s i m(a,b)}}&{{=}}&{{(1-\alpha)\times\mathit{l o c a l S i m(a,b)}}}\\ {{}}&{{}}&{{+}}&{{\alpha\times\mathit{s t r c u c t S i m(a,b),}}}\end{array}\tag{1}$$
where 0 ≤ α ≤ **1 is a weight for adjusting contributions from**
localSim(,) and structSim(,**). We judge whether two nodes**
are similar if the similarity is greater than the threshold, τ .
4.2.1 Local Similarity
The local similarity of nodes a and b **is composed of (1)**
name similarity and (2) tag distribution similarity. Name
similarity can be any string similarity metric, which returns
a value ranging from 0 to 1. Tag similarity, tagSim(,**), can**
be any function for measuring the similarity of distributions.
Because of the sparseness of the data, and to make the computation fast, we use a simple function which counts the
number of common tags, n, in the top K tags of a and b;
it returns 1 if this number is equal or greater than J**, else**
it returns n
J

. Local similary is a weighted combination of
name and tag similarities:
Tag similarity helps address the ambiguity **challenge described in Section 3. For example, the top tags of the node**
turkey **that refers to a bird include "bird", "beak", "feed",**
while the top tags of turkey **that refers to the country include different terms about places within the country.**
$$\begin{array}{r c l}{{l c o c a l S i m(a,b)}}&{{=}}&{{\beta\times n a m e S i m(a,b)}}\\ {{}}&{{}}&{{+}}&{{(1-\beta)\times t a g S i m(a,b)).}}\end{array}\tag{2}$$
4.2.2 Structural Similarity Structural similarity between two nodes depends on position of nodes within their saplings. We define two versions: structSimRR(,**) which computes structural similarity between two root nodes (root-to-root similarity), and**
structSimLR(,**) which evaluates structural similarity between a root of one sapling and the leaf of another (leaf-toroot similarity).**
Root-to-Root similarity. Two saplings A and B **are likely**
to describe the same concept if their root nodes r A and r B
have a similar name and some of their leaf nodes also have similar names. In this case, there is no need to compute tagSim(,**) of these leaf nodes. We define the normalized**
common leaves factor, CL**, as** 1Z
Pi,j δ(**name**(l A
i )**, name**(l B
j )),
where δ(., .**) returns 1 if the both arguments are exactly the** same; otherwise, it returns 0; **name**(l A
i **) is a function that**
returns the name of a leaf node l A
i of sapling A. Z **is a normalizing constant, which is described in greater detail later.**
Structural similarity between two root nodes is then defined as follows:

$$\begin{array}{r c l}{{s t r c t S i m R R(r^{A},r^{B})=\mathbb{C L}}}&{{+}}&{{(1-\mathbb{C L})}}\\ {{}}&{{}}&{{}}\\ {{}}&{{}}&{{\times}}&{{t a g S i m(\hat{\mathbb{L}}_{t a g}^{A},\hat{\mathbb{L}}_{t a g}^{B}),}}\end{array}$$

where L`A
tag **is an aggregation of tag distributions of all** l A
i, at which **name**(l A
i ) 6= **name**(l B
j **) for any leaf node** l B
j **of the**
sapling B**. From Eq. 3, we compute similarity based on:**
(1) how many of their children have common name (they match); (2) the tag distribution similarity of those that do not have the same name. The second term is an optimistic estimate that child nodes of the two saplings refer to the same concept while having different names.

The normalization coefficient Z = min(|l X|, |l Y|**), where**
|l X| is a number of child nodes of X. We use min(,**) instead**
of union. The reason is that saplings aggregated from many small saplings will contain a large number of child nodes.

When merging with a relatively small sapling, the fraction of common nodes may be very low compared to total number of child nodes. Hence, the normalization coefficient with the union (Z = **union**(l X , lY**)), as defined in Jaccard similarity,**
results in overly penalizing small saplings. min(,**), on the**
other hand, seems to correctly consider the proportion of children of the smaller sapling that overlap with the larger sapling.

When we decide that roots r A and r B **are similar, we**
merge saplings A and B with the mergeByRoot(A, B) operation. This operation creates a new sapling, M**, which**
combines structures and tag statistics of A and B. In particular, the tag statistics of the root of M **is a combination**
of those from r A and r B**. The leaves of** M, l M**, are a union**
of l A and l B. If there are leaves from A and B **that share a**
name, their tag statistics will be combined and attached to the corresponding leaf in M.

The width of the newly merged sapling will increase as more saplings are merged. Also, since we simply merge leaf nodes with similar names, and their roots also have similar names, leaf-to-leaf structural similarity structSimLL(,**) is**
not required. This operation addresses the sparseness **challenge mentioned in Section 3.**
Root-to-Leaf similarity. **Merging the root node of one sampling with the leaf node of another sapling extends the depth**
of the learned folksonomy. Since we consider a pair of nodes with different roles, their neighboring nodes also have different roles. This would appear to make them structurally