incompatible. However, in many cases, some overlap between siblings of one sapling and children of another sapling exists. Formally, suppose that we are considering similarity between leaf l A
i of sapling A **and root** r B **of sapling** B.

There might be some l A
k6=i of A **similar to** l B
j of B**. Consider Figure 2 (c). Suppose that we have already merged**
uk saplings. Now, there are two saplings uk → {**scotland**,
glasgow, edinburgh, london} and scotland → {**glasgow**, shetland}, and we would like to merge the two **scotland**s.

Since both uk and scotland saplings have glasgow in common, and the user placed glasgow under uk instead of scotland**, this** shortcut **contributes to the similarity between**
scotland **nodes. The structural similarity between leaf and**
root nodes that takes this type of shortcut into consideraion is:
structSimLR(l A
i, r B) = **structSimRR**(r A, r B). (4)
Specifically, this is simply the root-to-root structural similarity of r A and r B**, which measures overlap between siblings**
of l A
i **and children of** r B**. For the case when there is no shortcut, the similarity from this part will be dropped out; hence,**
the Eq. 1 will only be based on the local similarity.

## 4.3 Sap: Growing A Tree By Merging Saplings

We describe sap **algorithm, which uses operations defined**
above to incrementally grow a deeper, bushier tree by merging saplings created by different users. In order to learn a folksonomy corresponding to some concept, we start by providing a seed term, the name of that concept. The seed term will be the root of the learned tree. We cluster individual saplings whose roots have the same name as the seed by using the similarity measures Eq. 1, Eq. 2 and Eq. 3 to identify similar saplings. Saplings within the same cluster are merged into a bigger sapling using the **mergeByRoot**(,)
operation. Each merged sapling corresponds to a different sense of the seed term.

Next, we select one of the merged saplings as the starting point for growing the folksonomy for that concept. For each leaf of the initial sapling, we use the leaf name to retrieve all other saplings whose roots are similar to the name. We then merge saplings corresponding to different senses of this term as described above. The merged sapling whose root is most similar to the leaf (using similarity measures Eq. 1, Eq. 2 and Eq. 4), is then linked to the leaf. In the case that several saplings match the leaf, we merge all of them together before linking. Clustering saplings into different senses, and then merging relevant saplings to the leaves of the tree proceeds incrementally until some threshold is reached.

Suppose we start with saplings shown in Figure 2(c), and the seed term is uk. The process will first cluster uk **saplings.**
Suppose, for illustrative purposes, that there is only one sense of uk, resulting in a single sapling with root uk**. Next,**
the procedure selects one of the unlinked leaves, say glasgow, to work on. All saplings with root glasgow will be clustered, and the merged glasgow **sapling that is sufficiently**
similar to the glasgow leaf of the uk **sapling will then be**
linked to it at the leaf, and so on.

Handling Shortcuts. Attaching a sapling A **to the learned**
tree F can result in structural inconsistencies in F**. One type**
of inconsistency is a shortcut**, which arises when a leaf of** A is similar to a leaf of F**. In the illustration above, attaching**
the scotland sapling to the uk **tree will generate a shortcut,**

![0_image_0.png](0_image_0.png)

Figure 3: Appearance of mutual shortcuts between London and England when merging London and England saplings. To resolve them, we compare the similarity between UK-London and UK-England sapling pairs. Since England sapling is closer to UK than London sapling, we simply attach England sapling to the tree; while ignoring London leaf under UK.

or two possible paths from uk to **glasgow** (r uk → l uk glassgow and r uk → l uk scotland → l scotland glasgow **). Ideally, we would drop the**
shorter path and keep the longer one which captures more specific knowledge.

There are cases where the decision to drop the shorter path cannot be made immediately. Suppose we have uk → {london, england, scotland} **as the current learned tree,**
and are about to attach london → {british museum, dockland, england} to it. Unfortunately, some users placed england under london**, and attaching this sapling will create a**
shortcut to england**. The decision to eliminate the shorter**
path to england **cannot be made at this point, since we have** no information about whether attaching the england **sapling** will also create a shortcut to london from the root (uk**). We**
have to postpone this decision until we retrieve all relevant saplings that can be attached to the present leaf (l uk london)
and its siblings (l uk england and l uk scotland).

Suppose that l uk england does match the root of sapling england → {london, manchester, liverpool}. Mutual shortcuts to england and london **would undesirably appear once**
all the saplings are attached to the tree. Hence, the decision to drop l uk england or l uk london **must be made. We base the decision on similarity. Intuitively, a sapling that is more similar,**
or "closer," to r uk **should be linked to the tree. Formally, the**
node to be kept is l uk xˆ, where ˆx = argmaxx{**nodesim**(r uk, rx)}
and x = {england, london}**, while the other will be dropped.**
This is illustrated in Figure 3.

Handling Loops. **Attaching a sapling to a leaf of the learned**
tree may result in another undesirable structure, a loop. Suppose that we are about to attach a sapling A **to the**
leaf l F
i of F**. A loop will appear if there exists a leaf** l A
j of A **with the same name as some node in the path from root** to l F
iin F**. In order to make the learned tree consistent, we**
must remove l A
j **before attaching the sapling. For instance,**
suppose we decide to attach london sapling to the **england**
sapling in Figure 3 at its london **node, we have to remove** england node of london **sapling first.**
In some cases, loops indicate synonymous concepts. In our data set, we found that there are users who specify the relation animal → fauna, and those who specify the inverse fauna → animal. Since animal and fauna have similar