meaning, we hypothesize that this conflict appears because of variations in users' expertise and categorization preferences.

To determine whether a loop is caused by a synonym, we check the similarity between r A and r F**. If it is high**
enough, we simply remove l F
jfrom F, for which **name**(l F
j ) =
name(l A
j **); then, merge** r A and r F**. The similarity measure is based on Eq. 1. More stringent criteria are required**
since r A and r Fhave different names. Specifically, we modify tagSim(X, Y ) to tagSimsyn(X, Y **), which instead evaluates** |τX∩τY | min(|τX |,|τY |)
, and modify structSim(X, Y ) to struct-Simsyn(X, Y **), which only evaluates** 1Z
Pi,j δ(**name**(l X
i ),
name(l Y
j )).

Mitigating Noisy Vocabularies. **As mentioned in Section 3,**
noisy nodes appear from idiosyncratic vocabularies, used by a small number of users. For a certain merged sapling, we can identify these nodes by the number of users who specified them. Specifically, we use 1% of the number of all users who "contribute" to this merged sapling as the threshold.

We then remove leaves of the sapling, that are specified by fewer number of users than the threshold.

Managing Complexity. **Computing the similarity measure**
for all pairs of saplings in the corpus is impractical, even considering local or structural similarity only. We address this scalability issue in two ways. First, we only compare sapling nodes if they share the same (stemmed) name. This reduces the total number of pairs which need to be compared and eliminates the need to compute nameSim(,**) in** Eq. 2. Second, we apply the blocking approach [11] for efficiently computing similarity and merging sapling roots. The basic idea behind this approach is to first use a cheap similarity measure to "roughly" group similar items. We can then thoroughly compute item similarities and merge them within each "roughly similar" group by using the more computationally expensive similarity measure. We assume that items judged to be dissimilar by the cheap measure will also be dissimilar when evaluated by the more expensive measure. Since the approach applies the expensive measure to a much smaller set of items, it reduces the time complexity of the clustering method.

In our case, we compute an inexpensive similarity measure based on the most frequent tags. Specifically, we map the top tags to some integer code, which can be cheaply sorted by any database. Subsequently, we use the database to sort saplings by their codes, moving roughly similar saplings to neighboring rows. The process begins by scanning sorted saplings in the database table on a sapling by sapling basis.

If the presently scanned sapling has not been merged with some other sapling, we add this sapling to the top of the queue. If the present sapling does belong to some merged sapling, we check if this sapling is also similar to some other merged saplings in the queue. We use Eq. 1, Eq. 2 and Eq. 3 to evaluate their similarity. If they are similar enough, we will merge them together into a new merged sapling; then add it to the top of the queue. The scanning is performed repeatedly until the number of merged saplings no longer changes.

## 4.4 Complexity Analysis

Here we sketch the computational complexity of sap. Basically, sap **can be decomposed into 2 different parts: (1)**
root-to-root merging, which expands folksonomies' width;
(2) leaf-to-root merging, which extends folksonomies' depth. These two parts are loosely dependent, i.e., one can cluster all saplings into different senses; then "vertically" merge the root of one sapling sense with a leaf of the other. Since we use blocking and only cluster saplings with the same stemmed names, the computational complexity depends on
(1) the number of unique stemmed names in the data set;
(2) the average number of saplings that share a name. Let N and M **be the number of nodes and the number of unique**
stemmed names in the data set respectively. Hence, for each stem, there are NM **nodes to be compared on average. We**
use database to first roughly sort saplings, which generally requires O(
N
M log( N
M **)). After saplings are sorted, they are**
scanned and merged. This is repeatedly, say in i **iterations,**
until the number of clusters no longer changes, which requires O(i ×
N
M **). In all, the complexity of the first part**
is O(**N log**(
N
M ) + iN**). Empirically, the number of clusters**
converges in 2-3 iterations on average.

Let b and d **be the branching factor and the depth of the**
tree we want to produce. In addition, suppose that there are s **sapling senses for each stemmed name on average. Since**
we have to traverse each inner node of the tree to attach relevant sapling senses, and for each of these nodes we need to compare the similarity to all sapling senses with similar root names, this requires O(s × b d).

Our earlier work, sig **[12], which is described in more detail in Section 5, only considered the best path from a root**
to a given leaf of the tree, and required enumerating all possible paths between them. In the best case, when there are no shortcuts or loops in the data set, the number of paths from the root to all leaves of a given tree is equal to the number of the leaves, and that only requires O(b d +b d−1**) to**
check whether each edge should be included. In the worst case, when shortcuts appear to all node pairs, we would need O(d+1 2
× b d**) to check all possible edges. Moreover,**
we also need to enumerate all possible paths for the root to all leaves of the tree, which requires O(1 + Pe=1:d−1 d−1 e
)
per root-to-leaf pair. Hence, we expect our approach to scale better than the previous one as the depth of the output tree increases and when there are many shortcuts.

## 5. Empirical Validation

We constructed a data set containing collections and their constituent sets (or collections) created by a subset of Flickr users who are members of seventeen public groups devoted to wildlife and nature photography [12]. These users had many other common interests, such as travel and sports, arts and crafts, and people and portraiture. We extracted all the tags associated with images in the set, and retrieved all other images that the user annotated with these tags. We constructed personal hierarchies, or saplings, from this data, with each sapling rooted at one of user's top-level collections.

For reasons described in Section 4.1, we ignore collections with composite names. This reduces the size of the data set to 20, 759 saplings created by 7, **121 users. A small number**
of these saplings are multi-level.

The folksonomy learning approach described in this paper has a number of parameters as shown in Table 1. In our experiment, we ignored the parameter β **since only sapling**
nodes with the same name are needed to be compared as described the previous section. To explore the range of these