We can also combine the value and variable symmetries. For example, if we apply the composition of the last two symmetries (that is, θinv ◦ σv) to (1), we reflect the solution in the vertical axis and invert all values giving another symmetric solution:

![0_image_0.png](0_image_0.png)

$$\mathbf{\Sigma}(4)$$

Note that (4) is itself the reflection of (3) in the vertical axis. The problem thus has 16 symmetries in total. ♣

## 3 Symmetry Breaking

One common way to deal with symmetry is to add constraints to eliminate symmetric solutions [15]. We shall show that we can in fact break symmetry by posting a *symmetry* of any such symmetry breaking constraints.

Running Example. Consider again the most-perfect magic square problem. To eliminate the symmetries of the square, we can post the constraints:
X1,1 < min(X1,n, Xn,1, Xn,n), X1,n < Xn,1 (5)
These ensure that the smallest corner is top left, and the bottom left corner is smaller than the top right. This eliminates all degrees of freedom to rotate and reflect the square. Note that (5) eliminates solutions (1) and (4) but leaves their reflections (2) and (3).

To eliminate the value symmetry θinv *and any rotations or reflections of it, we can post:*
X1,1 < n2 + 1 − max(X1,1, X1,n, Xn,1, Xn,n) (6)
This ensures that the smallest corner in the magic square is smaller than the smallest corner in any rotation or reflection of the inversion of the solution. Note that the smallest corner cannot equal *the inversion of any corner since the problem constraints of a most-perfect* magic square ensure that the inversion of any corner lies inside the square (in fact, on the diagonal). This symmetry breaking constraint eliminates (2) but leaves (3). Thus, of the four symmetric solutions given earlier, only (3) satisfies (5) and (6). ♣
One of our main observations is that *any symmetry* acting on a set of symmetry breaking constraints will itself break the symmetry in a problem. Different symmetries pick out different solutions in each symmetry class. To show this, we need to consider the action of a symmetry on a set of symmetry breaking constraints. Symmetry is often defined as acting on assignments, mapping solutions to solutions. We need to lift this definition to constraints. The action of a variable symmetry on a constraint changes the variables on which the constraint acts. More precisely, a variable symmetry σ applied to the constraint C(Xj **, . . . , X**k) gives C(Xσ(j)**, . . . , X**σ(k)). The action of a value symmetry is also easy to compute. A value symmetry θ applied to the constraint C(Xj **, . . . , X**k) gives C(θ(Xj )**, . . . , θ**(Xk)).

Running Example. To illustrate how we can break symmetry with the symmetry of a set of symmetry breaking constraints, we shall construct symmetries of (5) and (6).

Consider the symmetry σv *that reflects the square in the vertical* axis mapping X1,1 onto Xn,1 (and vice versa), and X1,n *onto* Xn,n
(and vice versa). If we apply σv *to (5) we get:*
Xn,1 < min(Xn,n, X1,1, X1,n), Xn,n < X1,1 (7)

These new symmetry breaking constraints ensure that the smallest corner is now top right, and the bottom right corner is smaller than
the top left. This again eliminates all degrees of freedom to *rotate and*
reflect the square. Note that (7) eliminates solutions (2) and (3) but leaves (1) and (4). This is the opposite of posting (5) which would leave (2) and (3), but eliminate (1) and (4).
If we apply σv to (6), we again get a constraint that breaks the
value symmetry θinv *and any rotations or reflections of it:*
Xn,1 < n2 + 1 − max(Xn,1, Xn,n, X1,1, X1,n) (8)
This again ensures that the smallest corner in the magic square is
smaller than the smallest corner in any rotation or reflection of the
inversion of the solution. This eliminates (1) but leaves (4). Thus, of the four symmetric solutions given earlier, only (4) satisfies the
symmetry σv of (5) and (6).
We can also break symmetry with any other symmetry of the symmetry breaking constraints. For instance, if we apply θinv ◦ σv *to (5)*
we get the constraints:
$n^{2}+1-X_{n,1}<\min(n^{2}+1-X_{n,n},n^{2}+1-X_{1,1},n^{2}+1-X_{1,n})$, $n^{2}+1-X_{n,n}<n^{2}+1-X_{1,1}$
These simplify to:
Similarly, if we apply θinv ◦ σv *to (6) we get the constraint:*
Xn,1 > n2 + 1 − min(Xn,1, Xn,n, X1,1, X1,n)
The three constraints ensure that the largest corner is top right, the
bottom right is larger than the top left, and the largest corner is
larger than the largest corner in any rotation or reflection of the inversion of the solution. This again prevents us from rotating, reflecting or inverting any solution. Of the four symmetric solutions given
earlier, only (2) satisfies θinv ◦ σv *of (5) and (6). We see therefore*
that different symmetries of the symmetry breaking constraints pick out different solutions in each symmetry class. ♣
$$X_{n,1}>\operatorname*{max}(X_{n,n},X_{1,1},X_{1,n})$$ $$X_{n,n}>X_{1,1}$$
$$f_{y}\,t o_{\cdot}$$
$$s t r a i m t.$$

## 4 Theoretical Results

The running example illustrates that we can break symmetry with a symmetry of a set of symmetry breaking constraints. We will prove that this holds in general. Our aim is to show:
Any symmetry acting on a set of symmetry breaking constraints itself breaks symmetry. Different symmetries pick out different solutions in each symmetry class.

We will consider the action of a symmetry on the solutions and symmetries of a set of symmetry breaking constraints. We will also study the action of a symmetry on the soundness and completeness of a set of symmetry breaking constraints, the representative solutions picked out by the symmetry breaking constraints and the symmetries that are eliminated. Finally we will consider what symmetries can be found within a set of symmetry breaking constraints.

## 4.1 Symmetry And Satisfiability

We start with the action of a symmetry on the satisfiability of a set of constraints. This simple result is used in some of the later proofs.

We write σ(C) for the result of applying the symmetry σ to the set of constraints C.