Proposition 1. For any symmetry σ, a set of constraints C is satisfiable iff σ(C) *is satisfiable.*
Proof: Suppose C is satisfiable. Then there exists a satisfying assignment A of C. By considering the action of a symmetry on a set of constraints, we can see that σ(A) satisfies σ(C). Thus σ(C) is satisfiable. The proof reverses easily. ✷

## 4.2 Symmetry And Solutions

We next consider the action of a symmetry on the solutions of a set of
(possibly symmetry breaking) constraints. We write sol(C) for the set of solutions to the set of constraints C. Proposition 2. For any symmetry σ *and set of constraints* C:
sol(σ(C)) = σ(sol(C))
Proof: Consider any solution A ∈ sol(σ(C)). We view a solution as a set of assignments. Then σ(C)∪A is satisfiable. As σ is a bijection, there exists a unique B such that A = σ(B). Thus σ(C) ∪ σ(B) is satisfiable. Hence σ(C ∪ B) is satisfiable. By Proposition 1, C ∪ B
is satisfiable. That is, B ∈ sol(C). Thus σ(B) ∈ σ(sol(C)). Hence A ∈ σ(sol(C)). The proof reverses directly. ✷
On the other hand, if we apply a symmetry to a set of constraints with that same symmetry, we do not change the set of solutions.

Proposition 3. If σ is a symmetry of a set of constraints C *then* sol(C) = σ(sol(C))
Proof: Consider any A ∈ σ(sol(C)). Then there exists B ∈ sol(C) such that A = σ(B). Since σ is a symmetry of C, σ(B) ∈ sol(C).

That is A ∈ sol(C). The proof reverses directly. ✷

## 4.3 Symmetries Under Symmetry

The action of a symmetry on a set of constraints also does not change the symmetries of those constraints.

Proposition 4. If Σ *is a symmetry group of a set of constraints* C then Σ is also a symmetry group of σ(C) *for any* σ ∈ Σ. Proof: Consider any solution A of σ(C) and any τ ∈ Σ. Since σ ∈ Σ, by Proposition 3, sol(σ(C)) = sol(C). Thus A ∈ sol(C).

As τ ∈ Σ, τ (A) ∈ sol(C). Hence τ (A) ∈ sol(σ(C)). It follows that τ is a symmetry of σ(C). ✷

## 4.4 Symmetry And Soundness

An important property of a set of symmetry breaking constraints is its soundness. For a problem with symmetries Σ, a set of symmetry breaking constraints is *sound* iff it leaves at least one solution in each symmetry class. All the symmetry breaking constraints used in our running example are sound. The action of a symmetry on a set of symmetry breaking constraints leaves their soundness unchanged.

Proposition 5 (Soundness). Given a set of symmetries Σ of C*, if* S
is a sound set of symmetry breaking constraints for Σ then σ(S) for any σ ∈ Σ *is also a sound set of symmetry breaking constraints for* Σ. Proof: Consider any A ∈ sol(C ∪ S) and any σ ∈ Σ. Now A ∈ sol(C) and A ∈ sol(S). But as σ is a symmetry of C, σ(A) ∈ sol(C). Since A ∈ sol(S), it follows from Proposition 2 that σ(A) ∈ sol(σ(S)). Thus, σ(A) ∈ sol(C ∪σ(S)). Hence, there is at least one solution left by Σ(S) in every symmetry class of C.

That is, σ(S) is a sound set of symmetry breaking constraints for Σ.

✷

## 4.5 Symmetry And Completeness

A set of symmetry breaking constraints may also be complete. For a problem with symmetries Σ, a set of symmetry breaking constraints is *complete* iff it leaves at most one solution in each symmetry class. The action of a symmetry on a set of symmetry breaking constraints leaves their completeness unchanged.

Proposition 6 (Completeness). *Given a set of symmetries* Σ of C,
if S is a complete set of symmetry breaking constraints for Σ *then* σ(S) for any σ ∈ Σ *is also a complete set of symmetry breaking* constraints for Σ.

Proof: Consider any σ ∈ Σ and A ∈ sol(C ∪ σ(S)). Now A ∈ sol(C) and A ∈ sol(σ(S)). But as σ is a symmetry of C, so is σ
−1.

Hence σ
−1(A) ∈ sol(C). Since A ∈ sol(σ(S)), it follows from Proposition 2 that σ
−1(A) ∈ sol(S). Thus σ
−1(A) ∈ sol(C ∪ S).

Hence, there is at most one solution left by σ(S) in every symmetry class of C). That is, σ(S) is a complete set of symmetry breaking constraints for Σ. ✷

## 4.6 Representative Solutions

Different symmetries of the symmetry breaking constraints pick out different solutions in each symmetry class. In fact, we can pick out any solution we like by choosing the appropriate symmetry of a set of symmetry breaking constraints.

Proposition 7. Given a symmetry group Σ of a set of constraints C,
a sound set S *of symmetry breaking constraints, and any solution* A
of C, then there is a symmetry σ ∈ Σ *such that* A ∈ sol(C ∪ σ(S)).

Proof: Since the set of symmetry breaking constraints S is sound, it leaves at least one solution (call it B) in the same symmetry class as A. That is, B ∈ sol(C∪S). Hence B ∈ sol(C) and B ∈ sol(S). As A and B are in the same symmetry class, there exists a symmetry σ in Σ with A = σ(B). Since B ∈ sol(S), it follows from Proposition 2 that σ(B) ∈ sol(σ(S)). That is, A ∈ sol(σ(S)). As B ∈ sol(C)
and σ ∈ Σ, it follows that σ(B) ∈ sol(C). That is, A ∈ sol(C).

Hence A ∈ sol(C ∪ σ(S)). ✷
We will use this result in the second half of the paper where we consider the conflict between symmetry breaking constraints and branching heuristics. We will exploit the fact that whatever solution the branching heuristic is going towards, there exists a symmetry of the symmetry breaking constraints which does not conflict with this.

## 4.7 Symmetries Eliminated

In certain cases, a set of symmetry breaking constraints completely eliminates a symmetry. We say that a set of symmetry breaking constraints S *breaks* a symmetry σ of a problem C iff there exists a solution A of C ∪ S such that σ(A) is not a solution of C ∪ S, and eliminates a symmetry σ iff for each solution A of C ∪ S, σ(A) is not a solution of C ∪ S. Similarly, S breaks (eliminates) a set of symmetries Σ iff S breaks (eliminates) each σ ∈ Σ.

It is not hard to see that a sound and complete set of symmetry breaking constraints eliminates every non-identity symmetry. However, there are symmetry breaking constraints which break a particular symmetry but do not *eliminate* it.

Running Example. *Consider again one of the symmetry breaking* constraints in (7):