constraints interact in different ways with the problem constraints.

Although the problem constraints are themselves initially symmetrical, branching decisions quickly break the symmetries that they have.

## 6 Experimental Results

Our experiments are designed to test two hypotheses. The first hypothesis is that model restarts is less sensitive to branching heuristics than posting static symmetry breaking constraints. We test this hypothesis by using either a lexicographic value ordering (which does not conflict with the symmetry breaking constraints) or random value ordering, while using min-domain for variable ordering. We expect that model restarts will show smaller variation between the two value ordering heuristics. The second hypothesis is that model restarts will often explore a smaller search tree than dynamic methods like SBDS
due to propagation of the symmetry breaking constraints. We tested two domains that exhibit two different kinds of symmetry: partial variable and value interchangability, and row and column symmetry.

We limit our comparison of dynamic methods to SBDS. Whilst there is a specialized dynamic symmetry breaking method for interchangeable variables and values, experiments in [10] show that this is several orders of magnitude slower than static methods. We also do not compare to methods such as GE-trees [17], as this method is limited to value symmetry and does not deal with the variable/value symmetries in our domains. Finally, we used SBDS to break just generators of the symmetry group as breaking the full symmetry group quickly exhausted available memory. We implemented model restarts and SBDS as well as all the static symmetry breaking constraints in Gecode 2.2.0, and ran all experiments on a 4-core Intel Xeon 5130 with 4MB of L2 cache running at 2GHz.

The first set of experiments uses random graph coloring problems generated in the same way as the previous experimental study in [13].

All values in this model are interchangeable. In addition, we introduce variable symmetry by partitioning variables into interchangeable sets of size at most 8. We randomly connect the vertices within each partition with either a complete graph or an empty graph, and choose each option with equal probability. Similarly, between any two partitions there is equal probability that the partitions are completely connected or independent. Results for graphs with 40 vertices are shown in Table 1.

The second set of experiments uses Equidistant Frequency Permutation Array (EFPA) problem [11]. Given the parameters **v, q, λ, d**,
the objective is to find v codewords of length qλ, such that each word contains exactly λ occurences of each of q symbols and each pair of words have Hamming distance d. Our model has both row and column symmetry. We implement model restarts by randomly choosing a permutation of the rows and columns and posting lexicographic ordering constraints on the rows and columns of the resulting matrix.

The results support both our hypotheses. Although the model restarts method is not necessarily the best method for any given instance, its performance is most robust. The variability of the runtimes between the lex value ordering and random value ordering is much smaller for model restarts, as well as for SBDS. This suggests that in domains where the branching heuristic interacts more strongly with the problem constraints, model restarts will be more robust than static symmetry breaking constraints. Our second hypothesis, that model restarting tends to explore a smaller search tree than SBDS
is also supported by the graph coloring results. SBDS was unable to prove optimality in all but one instance in graph coloring. These results confirm the findings of [10]. In EFPA on the other hand, there are enough solutions in these instances that applying little symmetry breaking with a random value ordering seems to be the best strategy. However, on the harder instances such as 4-6-4-5, using model restarts resolves the conflict between the branching heuristic and the symmetry breaking constraints and achieves parity with SBDS.

## 7 Other Related Work

Crawford *et al.* proposed a general method to break symmetry statically using lex-leader constraints [2]. Like other static methods, the posted constraints pick out in advance a particular solution in each symmetry class. Unfortunately, this may conflict with the solution sought by the branching heuristic. There are a number of symmetry breaking methods proposed to deal with this conflict. For example, dynamic symmetry breaking methods like SBDS posts symmetry breaking constraints dynamically during search [7]. Another dynamic method for breaking symmetry is SBDD [3]. This checks if a node of the search tree is symmetric to some previously explored node. A weakness of such dynamic methods is that we get little or no propagation on the symmetry breaking constraints. It has been shown that propagation between the problem constraints and the static symmetry breaking constraints can reduce search exponentially [20].

Jefferson *et al,* have proposed GAPLex, a hybrid method that combines together static and dynamic symmetry breaking [12]. However, GAPLex is limited to dynamically posting lexicographical ordering constraints, and to searching with a fixed variable ordering. Puget has proposed "Dynamic Lex", a hybrid method that dynamically posts static symmetry breaking constraints during search which works with dynamic variable ordering heuristics [16]. This method adds symmetry breaking constraints dynamically during search that are compatible with the current partial assignment. In this way, the first solution found during tree search is not removed by symmetry breaking.

Dynamic Lex needs to compute the stabilizers of the current partial assignment. This requires a graph isomorphism problem to be solved at each node of the search tree. Whilst Dynamic Lex works with dynamic variable ordering heuristics, it assumes that values are tried in order. Finally Dynamic Lex is limited to posting lexicographical ordering constraints. A comparison with Dynamic Lex is interesting but challenging. For instance, Heller *et al.* [10] did not compare model restarts with Dynamic Lex, arguing:
"It is not clear how this method [Dynamic Lex] can be generalized, though, and for the case of piecewise variable and value symmetry, no method with similar properties is known yet."

## 8 Conclusions

We have considered the action of symmetry on symmetry breaking constraints. We proved that any symmetry applied to a set of symmetry breaking constraints gives a (possibly new) set of symmetry breaking constraints that break the same symmetries. In addition, we proved that different symmetries of the set of symmetry breaking constraints will pick out different solutions in each symmetry class.

We used these observations to help tackle the conflict between symmetry breaking and branching heuristics. In particular, we applied these ideas to *model restarts* [10]. In this search technique, we periodically restart search with a new model which contains a random symmetry of the symmetry breaking constraints. Experimental results show that this helps keep many of the benefits of posting static symmetry breaking constraints whilst reducing the conflict between symmetry breaking and the branching heuristic. There are other potential applications of these ideas. For example, we are currently de-